<?php

namespace util;
use think\facade\Db;

class SystemRedis extends RedisUtil
{
    /* 获取 基础设置*/
    public static function getConfig()
    {
        $key = 'ADMIN_CONFIG';
        if (!self::redis()->exists($key)) {
            self::cacheConfig();
        }
        //self::cacheConfig();
        $getdata = self::redis()->get($key) ?? '';
        $data = $getdata ? unserialize($getdata) : null;
        return $data ?? false;
    }
    /* 缓存 基础设置*/
    public static function cacheConfig()
    {
        $key  = 'ADMIN_CONFIG';
        $data = Db::name('admin_config')->where(['status' => 1])->field('name,value')->select()->toArray();
        if (is_null($data)) return false;
        $json = [];
        foreach ($data as $k => $value) {
            $json[$value['name']] = $value['value'];
        }
        
        $res = self::redis()->Set($key, serialize($json));
        
        return $res ?? false;
    }
    
}
