<?php
namespace util;

class SmsCodeRedis extends RedisUtil
{

    /**
     * 缓存短信验证码
     *
     * -- 使用Redis集合类型
     * -- 将每个用户发送的注册验证码都存入缓存集合
     *
     * @param string $mobile 手机号
     * @param string $code 验证码
     */
    public static function cacheSmsCode($mobile, $code)
    {
        $key = "sms_code";
        self::redis()->sAdd($key, $mobile . '|' . $code);
        self::redis()->expireAt($key, self::midnight());
    }
    /**
     * 短信验证码是否存在
     *
     * @param string $mobile 手机号
     * @param string $code 验证码
     *
     * @return bool
     */
    public static function isSmsCodeExist($mobile, $code)
    {
        $key = 'sms_code';
        return self::redis()->sIsMember($key, $mobile . '|' . $code);
    }
    /**
     * 删除短信验证码
     *
     * @param string $mobile 手机号
     * @param string $code 验证码
     */
    public static function deleteSmsCode($mobile, $code)
    {
        $key = 'sms_code';
        self::redis()->sRem($key, $mobile . '|' . $code);
    }

}
