<?php
namespace util;
use app\apicom\model\Stock;
use think\facade\Db;
class SearchRedis extends RedisUtil
{
    /**
     * 搜索股票
     * -- 股票代码
     * -- 股票首字母
     * -- 名称
     *
     * @param string $keyword 关键词
     *
     */
    public static function search($keyword)
    {
        if (preg_match('/^\d+$/', $keyword)) {
            // 股票代码搜索
            $list = Stock::where('code',   'LIKE', "%{$keyword}%")->field('code,title,pinyin,market')->order('code', 'ASC')->limit(50)->select()->toArray();
            return $list ?? [];
        } elseif (preg_match('/^[A-Za-z]+$/', $keyword)) {
            // 首字母搜索
            $list = Stock::where('pinyin', 'LIKE', "%{$keyword}%")->field('code,title,pinyin,market')->order('code', 'ASC')->limit(50)->select()->toArray();
        } else {
            // 名称搜索
            $list = Stock::where('title',  'LIKE', "%{$keyword}%")->field('code,title,pinyin,market')->order('code', 'ASC')->limit(50)->select()->toArray();
        }
        return $list ?? [];
    }
}
