<?php
namespace util;
use think\facade\Db;
class BorrowRedis extends RedisUtil
{
    /**
     * 加入终止操盘列表
     * -- 用于后端轮询
     *
     * @param borrow_id
     */
    public static function addRenewalLists($bid)
    {
        try {
            $key   = 'stop_renewal_lists';
            self::redis()->sAdd($key, $bid);
            self::redis()->expireAt($key, self::midnight());
        } catch (\Exception $e) {
            
        } catch (\Throwable $e) {
            
        }
    }
    /*
     * 获取审核列表
     */
    public static function getRenewalLists() 
    {
        $key  = 'stop_renewal_lists';
        // 取最新的持仓列表
        if(!self::redis()->exists($key)){
            self::initialization();
        }
        $list = self::redis()->sMembers($key);
        //$list = array_chunk($list,LOCAL_STOCK_COUNT,true);
        return $list;
    }
    /**
     * 初始化审核列表
     * -- 用于后端轮询审核列表
     */
    public static function initialization()
    {
        try {
            // 删除列表
            $key     = 'stop_renewal_lists';
            $lastKey = 'stop_renewal_lists_last';
            self::redis()->del($key);
            self::redis()->del($lastKey);
            // 获取待审核的终止列表列表
            $list = Db::name('stock_renewal')->where(['type'=>2,'status'=>0])->order('id desc')->select();
            //$list = array_unique_fb($list,['id']);//二维数组去重
            self::redis()->sAddArray($key, $list);
            self::redis()->expireAt($key, self::midnight());
        } catch (\Exception $e) {
            
        } catch (\Throwable $e) {
            
        }
    }
    
}