<?php
namespace app\apicom\validate;

use think\Validate;

class Trade extends Validate
{

    protected $rule = [
        'subid'  => 'require|number',
        'code'   => 'require|number|length:6',
        'market' => 'require|in:SH,SZ,BJ',
        'count'  => 'require|number|gt:0',
        'price'  => 'require',
    ];

    protected $message = [
        'subid.require' => '参数格式错误',
        'code.require'  => '参数格式错误',
        'code.number'   => '参数格式错误',
        'code.length'   => '参数格式错误',
        'count.require' => '请填写委托股数',
        'count.number'  => '委托股数格式错误',
        'count.gt'      => '委托股数格式错误',
        'market.require' => '参数格式错误',
        'market.in'      => '参数格式错误',
        
    ];

    protected $scene = [
        'trade' => ['subid', 'code', 'market', 'count', 'price'],
    ];

}
