<?php
namespace app\apicom\validate;

use think\Validate;

class BankCard extends Validate
{

    protected $rule = [
        'real_name'           => 'require',
        //'id'                  => 'require|id',
        //'mid'                 => 'require|mid',
        'bank'                => 'require',
        //'bank_name'           => 'require',
        'province'            => 'require',
        'city'                => 'require',
        'branch'              => 'require',
        'card'                => 'require',
        //'confirm_bank_number' => 'require|confirm:bank_number',
    ];

    protected $message = [
        'real_name.require'           => '请填写持卡人姓名',
        //'id_card_number.require'      => '请填写身份证号',
        //'id_card_number.idCard'       => '身份证号码不正确',
        //'mid.require'                 => '请填登陆后再操作',
        'bank.require'                => '请选择开户行',
        //'bank_name.require'           => '请选择开户行',
        'province.require'            => '请选择开户行所在省',
        'city.require'                => '请选择开户行所在市',
        'branch.require'              => '请填写开户支行名称',
        'card.require'                => '请填写银行卡号',
    ];

    /**
     * 完善银行卡信息的验证
     * @return UserBankCard
     */
    public function sceneComplete()
    {
        return $this->only(['id', 'mid', 'bank', 'province', 'city', 'branch', 'card', 'real_name']);
    }
    
}
