<?php
namespace app\apicom\model;
use app\apicom\model\Role as RoleModel;
use app\apicom\model\Record;
use app\apicom\model\Bank as BankModel;
use think\Model;
use think\facade\Db;
use think\Exception;

class Withdraw extends Model
{
    
    // 设置当前模型对应的完整数据表名称
    protected $name = 'money_withdraw';

	// 自动写入时间戳
	protected $autoWriteTimestamp = true;

    public function setCreateTimeAttr()
    {
    	return time();
    }

    public function setCreateIpAttr()
    {
    	return getClientIp();
    }

    public function getStatusAttr($value, $data)
    {
    	$status = [0=>'等待处理', 1=>'提现成功', 2=>'提现失败', 3=>'失败退回'];
    	return $status[$data['status']];
    }

    public static function  getAll($map=[], $order='',$listRows=20)
    {
        $data_list = self::view('money_withdraw w', true)
            ->view('member m', 'mobile, name', 'm.id=w.mid', 'left')
            ->where($map)
            ->order($order)
            ->paginate($listRows, false, ['query' => request()->param()])
            ->each( function($item, $key){
                $item->money = money_convert($item->money);
                $item->fee   = money_convert($item->fee);
            });
        return $data_list;

    }
    /**
     * 根据ID获取记录
     */
    public static function getRecordById($id,$listRows=20)
    {
        $res = self::where(['mid'=>$id])
            ->order('id desc')
            ->paginate($listRows, false, ['query' => request()->param()])
            ->each( function($item, $key){
                $item->money    = money_convert($item->money);
            });
        return $res;
    }
    
    public static function saveData($parameter)
    {
        $bank_id = $parameter['bank_id'];
        $bank = BankModel::bankInfo($bank_id);
        //print_r($bank);exit;
        $where['id'] = $parameter['mid'];//会员ID
        $where['status'] = 1;//会员状态
        $names = Db::name('member')->field('name')->where($where)->find();
        $data['bank']        = $bank['bank_name']."|".$bank['card'].'|'.$bank['province'].$bank['city'].$bank['branch']."|".$names['name'];
        $data['mid']         = $parameter['mid'];
        $data['money']       = $parameter['money'];
        $data['order_no']    = 'tx'.generate_rand_str(10, 3);
        $data['create_time'] = time();
        $data['create_ip']   = getClientIp();
        //print_r($data);exit;
        $record = new record;
        Db::startTrans();
        $money_info = Db::name('money')->where('mid', $data['mid'])->lock(true)->find();
        $account = bcsub(strval($money_info['account']), strval($data['money']));
        $up_money['freeze']  = bcadd($money_info['freeze'], $data['money']);
        $up_money['account'] = $account;
        $info = "提现冻结金额".($data['money'])."元,提现单号：".$data['order_no'];
        try{
            $res1 = self::create($data);
            $res2 = $record->saveData($data['mid'], -$data['money'], $account, 2, $info);
            $res3 = Db::name('money')->where('mid', $data['mid'])->update($up_money); 
            if($res1 && $res2 && $res3){
                Db::commit();
                return ['status'=>1, 'message'=>'提交成功'];
            }else{
                Db::rollback();
                return ['status'=>0, 'message'=>'提交失败'];
            }
        }catch(\Exception $e){
            Db::rollback();
            return ['status'=>0, 'message'=>'数据异常'];
        }
    }

}
?>
