<?php
namespace app\apicom\model;
use think\Model;
use think\facade\Db;

class StockSubAccount extends Base
{
    // 设置当前模型对应的完整数据表名称
    protected $table = 'stock_subaccount';
    // 自动写入时间戳
    protected $autoWriteTimestamp = true;
    
    public static function getAccountById($id){
        $result=Db::name('stock_subaccount')->field(true)->where(['id'=>$id])->select();
        if(empty($result))return null;
        return $result[0];
    }
    public static function getAccountByUid($uid){
        $result=Db::name('stock_subaccount')->field(true)->where(['uid'=>$uid])->select();
        if(empty($result))return null;
        return $result;
    }
    public static function getAccountByName($subaccount){
        $result=Db::name('stock_subaccount')->field(true)->where(['sub_account'=>$subaccount])->find();
        if(empty($result))return null;
        return $result;
    }
    //查询指定ID证券公司
    public static function getBroker($id){
        $result=Db::name('stock_account')->field(true)->where(['id'=>$id,])->find();
        if(empty($result))return null;
        return $result;
    }
    /*检测子账户是否属于该会员*/
    public static function CheckMemberSub($id,$subaccount){
        $result=Db::name('stock_subaccount')->field(true)->where(['id'=>$id,'sub_account'=>$subaccount])->find();
        if(empty($result))return null;
        return $result;
    }
    /*
     * 删除我子账号
     * @id 我子账号id
     */
    public static function delmyselect($id){
        $result = self::destroy($id);
        return $result;
    }
    
}