<?php
namespace app\apicom\model;
use think\Model;
use think\facade\Db;

class StockDealStock extends Base
{
    // 设置当前模型对应的完整数据表名称
    protected $name = 'stock_deal_stock';
    // 自动写入时间戳
    protected $autoWriteTimestamp = true;
    /*
     * 存储成交记录
     * $data 成交数据
     * $sub_id 子账号
     * $lid 安全模式id号
     * $user 证券账户
     * $soure 证券来源
     */
    
    /*
     * 返回子账号成交
     * $sub_id 子账号
     */
    public static function get_deal_stock($sub_id, $beginday='', $endday='', $page=1, $offset=15){

        $endday   = $endday ? $endday : date("Y-m-d",time());
        $beginday = $beginday ? $beginday : date("Y-m-d",time());
        
        $res = Db::view('stock_deal_stock deal')
            ->view('stock_subaccount sub','id,uid,sub_account','sub.id = deal.sub_id')
            ->view('stock_delivery_order order','business_name,stamp_duty,transfer_fee,commission,transaction_fee','order.deal_no = deal.deal_no')
            ->where(['deal.sub_id'=>$sub_id])
            ->where('deal.status','<>',0)
            //->whereTime('deal.deal_date', 'between', [$beginday, $endday])
            ->order('deal.id desc')
            ->paginate($offset, false, ['query' => request()->param()]);
        return $res;
    }
    /*
     * 存储模拟卖出成交记录
     * */
    public static function sell_m_deal_stock($stockinfo,$count,$price,$sub_id,$lid,$user,$soure,$Trust_no,$model){
        $row=array();
        $row[0]['sub_id'] = $sub_id;
        $row[0]['lid'] = $lid;//交易账户
        $row[0]['soruce'] = $soure;//证券来源
        $row[0]['login_name'] = $user;//证券账户
        $row[0]['deal_date'] = date('Y-m-d',time());//成交日期
        $row[0]['deal_time'] = date('H:i:s',time());//成交时间
        $row[0]['gupiao_code'] = $stockinfo['code'];//证券代码
        $row[0]['gupiao_name'] = $stockinfo['name'];//证券名称
        $row[0]['flag1'] = 1;//买卖标志1
        $row[0]['flag2'] = "证券卖出";//买卖标志2
        $row[0]['trust_price'] = $price;//委托价格
        $row[0]['trust_count'] = $count;//委托数量
        $row[0]['trust_no'] = $Trust_no;//委托编号
        $row[0]['deal_price'] = $price;//成交价格
        $row[0]['volume'] = $count;//成交数量
        $row[0]['amount'] = $price*$count;//成交金额
        $row[0]['deal_no'] = $Trust_no+521;//成交编号
        $row[0]['gudong_code'] = "";//股东代码
        $row[0]['type'] = $stockinfo["exchange_code"];//帐号类别
        if($model==1){
            $row[0]['cancel_order_flag'] = '0';//撤单标志 0、可撤
            $row[0]['status'] = "0";//状态说明
        }else{
            $row[0]['cancel_order_flag'] = '1';//撤单标志 1、已成交
            $row[0]['status'] = "卖出成交";//状态说明
        }
        $row[0]['info'] = "";//保留信息
        $row[0]['type_today'] = 1;//当日成交标识
        $result = Db::name('stock_deal_stock')->insertall($row,true);
        return $result;
    }
    /*
     * 存储模拟买入成交记录
     * $data 持仓数据
     * $sub_id 子账号
     * $lid 安全模式id号
     * $user 证券账户
     * $soure 证券来源
     */
    public static function add_m_deal_stock($stockinfo,$count,$price,$sub_id,$lid,$user,$soure,$Trust_no){
        $row = array();
        $row[0]['sub_id']      = $sub_id;
        $row[0]['lid']         = $lid;//交易账户
        $row[0]['soruce']      = $soure;//证券来源
        $row[0]['login_name']  = $user;//证券账户
        $row[0]['deal_date']   = date('Y-m-d',time());//成交日期
        $row[0]['deal_time']   = date('H:i:s',time());//成交时间
        $row[0]['gupiao_code'] = $stockinfo['code'];//证券代码
        $row[0]['gupiao_name'] = $stockinfo['name'];//证券名称
        $row[0]['flag1']       = 1;//买卖标志1
        $row[0]['flag2']       = "证券买入";//买卖标志2
        $row[0]['trust_price'] = $price;//委托价格
        $row[0]['trust_count'] = $count;//委托数量
        $row[0]['trust_no']    = $Trust_no;//委托编号
        $row[0]['deal_price']  = $price;//成交价格
        $row[0]['volume']      = $count;//成交数量
        $row[0]['amount']      = $price*$count;//成交金额
        $row[0]['deal_no']     = $Trust_no + 521;//成交编号
        $row[0]['gudong_code'] = "";//股东代码
        $row[0]['type']        = 0;//帐号类别
        $row[0]['market']      = $stockinfo["market"];//股票类别
        $row[0]['status']      = "买入成交";//状态说明
        $row[0]['info']        = "";//保留信息
        $row[0]['type_today']  = 1;//当日成交标识
        $row[0]['cancel_order_flag'] = '1';//撤单标志 1、已成交
        $result = Db::name('stock_deal_stock')->insertall($row,true);
        return $result;
    }


}