<?php
namespace app\apicom\model;

use think\Model;
use think\facade\Db;
/**
 * 会员模型
 */
class Stock extends Base
{
    // 设置当前模型对应的完整数据表名称
    protected $name = 'stock_list';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;
    
    public static function getAll($map=[], $order='',$listRows=20)
    {
        $data_list = self::where($map)
            ->order($order)
            ->paginate($listRows, false, ['query' => request()->param()])
            ->each( function($item, $key){
                $item->add_time  = date('Y-m-d H:i:s' ,$item->add_time);
                $item->edit_time = date('Y-m-d H:i:s',$item->edit_time);
            });
        return $data_list;
    }
}