<?php

namespace app\apicom\model;

use think\Model;
use think\facade\Db;
/**
 * 会员模型
 */
class Member extends Base
{
    // 设置当前模型对应的完整数据表名称
    protected $name = 'member';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;
    /**
     * 根据会员ID获取会员基本信息
     * @param array $id 会员ID
     * @return mixed
     */
    public static function getMemberInfoByID($id=null)
    {
        $where['m.id'] = $id;//会员ID
        $where['m.status'] = 1;//会员状态
        $data = self::view('member m', true)
            ->view("money", 'account,freeze,operate_account,bond_account', 'money.mid=m.id', 'left')
            ->where($where)
            ->find();
        return $data;
    }
    /**
     * 根据会员手机号获取会员基本信息
     * @param array $id 会员ID
     * @return mixed
     */
    public static function getMemberInfoByMobile($mobile=null)
    {
        $where['m.mobile'] = $mobile;//会员手机号
        $where['m.status'] = 1;//会员状态
        $data = self::view('member m', true)
            ->view("money", 'account,freeze,operate_account,bond_account', 'money.mid=m.id', 'left')
            ->where($where)
            ->find();
        return $data;
    }
    /**
     * 保存注册数据
     * @param  [type] $data [description]
     * @return [type]       [description]
     */
    public static function saveData($data)
    {
        $sdata['name']   = isset($data['name']) ? $data['name'] : '';
        $sdata['mobile'] = $data['mobile'];
        $sdata['passwd'] = password_hash($data['passwd'], PASSWORD_DEFAULT);
        $sdata['paywd']  = password_hash(substr($data['mobile'],-6,6), PASSWORD_DEFAULT);
        $sdata['pid']    = 0;
		$sdata['agent_far']   = isset($data['agent_far']) ? intval($data['agent_far']) : 0;
        $sdata['create_ip']   = getClientIp();
        $sdata['create_time'] = date('Y-m-d H:i:s',time());

        $result = self::create($sdata); 
        if($result->id){
            Db::name('money')->insert(['mid'=>$result->id]);
            $sdata['id']=$result->id;
            return ['status'=>1, 'message'=>'注册成功','data'=>$sdata];
        }else{
            return ['status'=>0, 'message'=>'注册失败'];
        }
    }
    /*
    * 返回代理商信息
    */
    public static function get_agents_info($mid)
    {
        $user = self::field('id,agent_id,agent_pro,agent_far,agent_rate')->where('id', $mid)->find();
        return $user;
    }
    /*
    * 返回当前用户返佣比例
    */
    public static function agents_back_rate($mid)
    {
        $user =  self::get_agents_info($mid);
        if($user['agent_rate'] && (!$user['agent_id'] || $user['agent_id']==1)){
            $rate = $user['agent_rate'];
        }else{
            if($user['agent_id'] ==2){
                $agent_1 =  self::get_agents_info($user['agent_far']);
                $rate = bcmul($agent_1['agent_rate'],$user['agent_rate'],2);
                $rate = bcdiv($rate,100,2);
            }elseif($user['agent_id']==3){
                $agent_1 =  self::get_agents_info($user['agent_far']);
                $agent_2 =  self::get_agents_info($agent_1['agent_far']);
                $agent_rate = $agent_1['agent_rate'] * $agent_2['agent_rate'];
                $rate = bcmul($agent_rate,$user['agent_rate'],2);
                $rate = bcdiv($rate,10000,2);
            }else $rate = sysConfig('member_back_rate');
        }
        return $rate;
    }
}