<?php
namespace app\apicom\model;

use think\facade\Db;
use think\Model;

/**
 * 会员模型
 */
class Invite extends Base
{
    // 设置当前模型对应的完整数据表名称
    protected $name = 'member_invitation_relation';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;

    /**
     * 保存推荐关系数据
     * @param  [type] $data [description]
     * @return [type]       [description]
     * @author gs101
     */
    public static function saveData($data)
    {
        $sdata['invitation_mid'] = $data['id'];
        $sdata['mid'] = $data['mid'];
        $sdata['create_time'] = time();
        $result = self::create($sdata);
        if($result->id){
            return ['status'=>1, 'message'=>'注册成功'];
        }else{
            return ['status'=>0, 'message'=>'注册失败'];
        }
    }
    /**
     * 获取推荐关系数据
     */
    public static function getAll($map=[], $order='',$listRows=20)
    {
        $data_list = self::view('member_invitation_relation r')
            ->view('member m','id,mobile,name','m.id = r.invitation_mid')
            ->where($map)
            ->order($order)
            ->paginate($listRows, false, ['query' => request()->param()])
            ->each( function($item, $key){
                $item->invitation_money = self::get_back_money($item->invitation_mid);
                //$item->agents_profit_money  = self::agents_profit_money($item->invitation_mid);
                //$item->profit_member        = self::get_users_m($item->invitation_mid);
                $item->real_name = $item['name'] ? $item['name'] : '未实名';
                $item->agent_des = $item->agent_id ? '代理商': '普通用户';
            });
        return $data_list;
    }
    
    
    /*
    * 邀请用户个数统计
    */
    public static function get_users_m($mid)
    {
        $count_m = Db::name('member_invitation_relation')->where('mid', $mid)->count();
        $count_m = $count_m ? $count_m : 0;
        return $count_m;
    }
    /*
    * 获取用户返佣收益
    */
    public static function get_back_money($mid)
    {
        $back_money = Db::name('agents_back_money')->where('affect_mid', $mid)->sum('affect');
        $back_money = $back_money ? $back_money : '0.00';
        return round($back_money,2);
    }
    /*
    *获取用户盈利
    */
    /*public static function agents_profit_money($mid)
    {
        $far_user = self::get_agents_info($mid);
        $arr = self::getSonAgentArr($mid);
        $arr_str= implode(',',$arr);
        if($arr_str !='') {
            $map =  "affect_mid in ({$arr_str}) and mid = {$far_user['agent_far']}";
        }else{
            return 0;
        }
        $back_money = Db::name('agents_back_money')->where($map)->sum('affect') ?: 0.00;
        return round($back_money,2);
    }*/
    /*
    * 返回代理商信息
    */
    /*public static function get_agents_info($mid)
    {
        $user = Db::name('member')->field('id,agent_id,agent_pro,agent_far,agent_rate')->where('id', $mid)->find();
        return $user;
    }*/
    /*
    *调取所有下级树 20 1 2 3
    */
    /*public static function getSonAgentArr($mid)
    {
        $user = Db::name('member')->field('id,agent_id')->where('agent_far', $mid)->select();
        $arr = array();
        if (!empty($user)){
            foreach ($user as $k=>$v){
                if($v['id']) array_push($arr,$v['id']);
                $user_info = self::getSonAgentArr2($v['id']);
                foreach ($user_info as $key=>$val){
                    if($val['id']) array_push($arr,$val['id']);
                }
            }
        }
        array_push($arr,$mid);
        return $arr;
    }
    public static function getSonAgentArr2($mid)
    {
        $arr = array();
        $user = Db::name('member')->field('id,agent_id')->where('agent_far', $mid)->select();
        return $user;
    }
    public static function getEndBack($time)
    {
        $time_n = time();
        $rate_time = config('member_back_time') ? config('member_back_time') : 0;
        $agent_time = $time + ($rate_time * 86400 * 30);
        if($agent_time > $time_n){
            $end_time = getTimeFormt($agent_time,5);
        }else{
            $end_time = '已到期';
        }

        return $end_time;
    }*/
}