<?php
namespace app\apicom\model;
use think\Model;
use think\Db;

class HistorySeacher extends Model{
    // 设置当前模型对应的完整数据表名称
    protected $name = 'stock_history';
    // 自动写入时间戳
    protected $autoWriteTimestamp = true;
    /*
     * 拖动置顶更新位置
     * $code 股票代码
     * $code_title 股票标题
     * $mid 用户id
     */
    public static function add_histtory($market,$code,$code_title,$mid){
        $mid  = intval($mid);
        $code = htmlspecialchars($code);
        $code_title = htmlspecialchars($code_title);

        $findArr = self::where("code", $code)->find();
        if(empty($findArr)){
            $row = array();
            $row['mid']        = $mid;
            $row['market']     = $market;
            $row['code']       = $code;
            $row['code_title'] = $code_title;
            $row['status']     = 1;//显示状态
            $row['count']      = 1;
            $row['add_time']   = time();//添加日期
            $result = self::insert($row,true);
        }else{
            $data['count'] = $findArr['count'] + 1;
            $result = self::where("code = {$code}")->update($data);
        }
        return $result;
    }
   
}