<?php
namespace app\apicom\model;
use think\model;
use think\facade\Db;

class Bank extends Base
{
    
    // 设置当前模型对应的完整数据表名称
    protected $name = 'member_bank';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;
    /*
     * 添加数据
     *
     */
    public static function saveData($data)
    {
        $result = self::create($data);
        if($result){
            return ['status'=>1, 'message'=>'添加成功'];
        }else{
            return ['status'=>0, 'message'=>'添加失败'];
        }
    }
    /*
     * 保存编辑数据
     *
     */
    public static function upEdit($data)
    {
        $result = self::where(['id'=>$data['id']])->update($data);
        if($result){
            return ['status'=>1, 'message'=>'修改成功'];
        }else{
            return ['status'=>0, 'message'=>'没有变动'];
        }
    }
    /*
     * 获取指定数据
     *
     */
    public static function getBank($mid)
    {
        $mid = intval($mid);
        $banks = self::where(['mid'=>$mid])->select();
        return $banks;
    }
    /*
     * 删除指定数据
     *
     */
    public static function del_bank($id){
       return self::where(['id'=>$id])->delete();
    }
    
    public static function bankInfo($bank_id)
    {      
        $list = explode(PHP_EOL,sysConfig('web_bank'));
        
        $rate_val = array();
        foreach ($list as $k => $v){
            $rate_val[preg_replace('/\|img/', '',explode(':',$v)[0])] = preg_replace('/\|img/', '',explode(':',$v)[1]);
        }
        $data['web_bank'] = $rate_val;
        $id   = intval($bank_id);
        $bank = self::where(['id'=>$id])->find()->toArray();
        //print_r($bank);exit;
		$bank['bank_name']    = $bank['bank_name'];
        $bank['bank']         = $rate_val[$bank['bank']] ?? '';
		$bank['provinces_id'] = $bank['province'];
		$bank['city_id']      = $bank['city'] ? $bank['city'] : 0;
        $bank['provinces']    = $bank['province'] ? $bank['province'] : 0;
        $bank['city']         = $bank['city'] ? areaList(null, $bank['city'])['name'] : '--';
        $bank['province']     = $bank['province'] ? areaList(null, $bank['province'])['name'] : '--';
        return $bank;
    }
}
?>
