<?php
declare (strict_types = 1);

namespace app\apicom\controller;
use app\apicom\model\Money;
use app\apicom\model\Member;
use think\facade\Request;

/**
 * 申请配资控制器
 */
class Stock extends BaseController
{
    /**
     * 免息配资
     * @return mixed
     */
    public function free_m()
    {

        $money_range   = explode('|', sysConfig('money_range'));
        $account_money = $this->userId ? Money::getMoney($this->userId)['account'] : 0;

        $data['free_loss']     = explode('|', sysConfig('free_loss'));
        $data['free_set']      = explode('|', sysConfig('free_set'));
        $data['account_money'] = money_convert($account_money);//bcdiv(strval($account_money),'100',2);
        $data['money_range']   = $money_range;
        $data['position']      = [];

        return ajaxmsg('免息配资',1,$data);
    }

    /**
     * 免费体验设置
     *
     * @return void
     */
    public function trial()
    {
        $d_money = sysConfig('free_taste_sysConfig.deposit_money');//自己出资
        $b_money = sysConfig('free_taste_sysConfig.borrow_money');//平台出资
        $t_day   = sysConfig('free_taste_sysConfig.taste_day');//天数
        //$data['is_skimp'] = sysConfig('free_taste_sysConfig.is_skimp');

        //return ajaxmsg('免费体验',1,$data);
        //$account_money = is_member_signin() ? Money::getMoney(is_member_signin())['account'] : 0;

        $data['account_money'] = $d_money;
        $data['setting'] = explode('|',$d_money."|".$b_money."|".$t_day);//sysConfig('trial_set')
        return ajaxmsg('免费体验', 1, $data);
    }

    /**
     * 按天配资
     * @return mixed
     */
    public function day()
    {
        $money_range   = explode('|', sysConfig('money_range'));
        $account_money = $this->userId ? Money::getMoney($this->userId)['account'] : 0;
        
        $day_use_time  = explode('|', sysConfig('day_use_time')); // 按天操盘期限
        $max_use_time  = max($day_use_time); // 最大使用天数
        $min_use_time  = min($day_use_time); // 最短使用时间
        $data['day_loss'] =  explode('|', sysConfig('day_loss')); //预警线|平仓线（按天）
        $rate_c = explode(PHP_EOL, sysConfig('day_rate'));
        $data['day_rate'] =  $rate_c; // 倍率及费率
        $rate_arr = array();
        foreach ($rate_c as $k => $v){
            array_push($rate_arr,$k+1);
        }
        $data['day_rate_a']    = $rate_arr;
        $data['day_use_time']  = $day_use_time;
        $data['max_use_time']  = $max_use_time;
        $data['min_use_time']  = $min_use_time;
        $data['account_money'] = $account_money;
        $data['account_money'] = rand(intval($account_money/100),2);
        $data['money_range']   = $money_range;
        $data['position']      = sysConfig('day_position');

        return ajaxmsg('按天配资',1,$data);

    }

    /**
     * 按周配资
     * @return mixed
     */
    public function week()
    {

        $money_range   = explode('|', sysConfig('money_range'));
        $account_money = $this->userId ? Money::getMoney($this->userId)['account'] : 0;
        $week_use_time = explode('|', sysConfig('week_use_time')); // 按周操盘期限
        $max_use_time  = max($week_use_time); // 最大使用时间
        $min_use_time  = min($week_use_time); // 最短使用时间

        $data['week_loss'] = explode('|', sysConfig('week_loss'));  //预警线|平仓线（按月）
        $data['week_rate'] = sysConfig('week_rate'); // 倍率及费率
        $rate_c   = explode(PHP_EOL,$data['week_rate']);
        $rate_arr = array();
        foreach ($rate_c as $k => $v){
            array_push($rate_arr,$k+1);
        }
        $data['week_rate_a']   = $rate_arr;
        $data['week_use_time'] = $week_use_time;
        $data['max_use_time']  = $max_use_time;
        $data['min_use_time']  = $min_use_time;
        $data['account_money'] = rand(intval($account_money/100),2);
        $data['money_range']   = $money_range;
        $data['position']      = sysConfig('week_position');

        return ajaxmsg('按周配资',1,$data);

    }

    /**
     * 按月配资
     * @return mixed
     */
    public function month()
    {
        $money_range    = explode('|', sysConfig('money_range'));
        $account_money  = $this->userId ? Money::getMoney($this->userId)['account'] : 0;
        $month_use_time = explode('|', sysConfig('month_use_time')); // 按月操盘期限
        $max_use_time   = max($month_use_time); // 最大使用时间
        $min_use_time   = min($month_use_time); // 最短使用时间
        $data['month_loss'] = explode('|', sysConfig('month_loss')); //预警线|平仓线（按月）
        $data['month_rate'] = sysConfig('month_rate'); // 倍率及费率
        $rate_c   = explode(PHP_EOL,$data['month_rate']);
        $rate_arr = array();
        foreach ($rate_c as $k => $v){
            array_push($rate_arr,$k+1);
        }
        $data['month_rate_a']   = $rate_arr;
        $data['month_use_time'] = $month_use_time;
        $data['max_use_time']   = $max_use_time;
        $data['min_use_time']   = $min_use_time;
        $data['account_money']  = rand(intval($account_money/100),2);
        $data['money_range']    = $money_range;
        $data['position']       = sysConfig('month_position');

        return ajaxmsg('按月配资',1,$data);

    }
    /*
     * 实盘交易平台操盘协议
     */
    public function protocol(){

        $info = file_get_contents(sysConfig('data_backup_path')."contract.txt");
        if(!$info) return ajaxmsg('没有协议内容',1,$info);
        $arr=array(
            "name"            => sysConfig('set_site_company_name'),//甲方：委托人
            "dizhi"           => sysConfig('web_site_address'),//甲方地址
            "borrowMoney"     => "--",//委托金额
            "borrow_duration" => "--",//配资周期
            "type"            => "天",//配资类型
            "investor"        => "--",//总利息
            "user_name"       => "--",//乙方用户名
            "real_name"       => "--",//
            "idcard"          => "--",//
            "WEB_URL"         => http().$_SERVER["HTTP_HOST"],//
            "web_name"        => sysConfig('web_site_title'),//
            "rate"            => "--",//
            "deposit_money"   => "--",//
            "add_time"        => "--",//
            "end_time"        => "--",//
        );
        if(!$this->userId){
            foreach ($arr as $k =>$v){
                $info = str_replace("[".$k."]",$v,$info);
            }
        }else{
            $minfo = Member::getMemberInfoByID($this->userId);
            $arr['user_name'] = isset($minfo['mobile']) ? $minfo['mobile']:"138********";
            $arr['real_name'] = isset($minfo['name'])   ? $minfo['name']:"***";
            $arr['idcard']    = isset($minfo['id_card'])? $minfo['id_card']:"******************";
            foreach ($arr as $k =>$v){
                $info=str_replace("[".$k."]",$v,$info);
            }
        }
        return ajaxmsg('实盘交易平台操盘协议',1,$info);
    }

}