<?php
declare (strict_types = 1);

namespace app\apicom\controller;
use app\apicom\model\Message as Msg;
use think\facade\Db;

class Message extends BaseController
{

    /**
     * 消息首页
     */
    public function index()
    {

        $status = $this->request->get('t');
        $map = [];
        if (isset($status)) $map['mm.status'] = $status;
        $map['mm.mid'] = $this->userId;
        $order = 'mm.id desc';
        // 数据列表
        $data= Msg::getAll($map, $order, 12);
        /*$data->each(function($item, $key){
            $item->create_time = getTimeFormt($item->create_time,7);
        });*/
        return ajaxmsg('获取成功',1,$data);
    }

    /**
     * 阅读消息
     */

    public function read()
    {
        $map = [];
        $message_id = $this->request->post("id");
        $map['id']  = $message_id;
        $map['mid'] = $this->userId;

        $messageModel = new Msg;
        $result = $messageModel
            ->where($map)
            ->update(['status' => 1]);
        if ($result == 1) {
            return ajaxmsg('设置为阅读',1);
        } else {
            return ajaxmsg('请求数据有误',0);
        }
    }
    /**
     * 批量阅读未读消息
     */
    public function readall(){
        $map = [];
        $map['mid'] = $this->userId;
        $messageModel = new Msg;
        $result = $messageModel
            ->where($map)
            ->update(['status' => 1]);
        return ajaxmsg('设置为阅读',1);
    }
    /**
     * 站内信页面
     * 显示：最新网站公告
     * 显示：最新系统通知
     */
    public function messageList(){
        $gao = Db::name('cms_document')
            ->alias('c')
            ->join('cms_document_news d','c.id = d.aid')
            ->where('c.cid', 2)
            ->order('c.id desc')
            ->find();

        $messgae = Db::name('member_message')
            ->alias('m')
            ->where('m.mid', '=' ,$this->userId)
            ->order('m.id desc')
            ->find();
        //判空
        if(!empty($gao)){
            $gao['create_time'] = getTimeFormt($gao['create_time'],1);
            $data['notice'] = $gao;
        }

        if(!empty($messgae)){
            $messgae['create_time'] = getTimeFormt($messgae['create_time'],1);
            $data['messgae'] = $messgae;
        }
        return ajaxmsg('获取成功',1,$data);
    }
}