<?php
declare (strict_types = 1);

namespace app\apicom\controller;
use app\apicom\model\Member;
use app\apicom\model\Invite as InviteModel;
use think\facade\Db;

use Endroid\QrCode\Builder\Builder;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel\ErrorCorrectionLevelHigh;
use Endroid\QrCode\Label\Alignment\LabelAlignmentCenter;
use Endroid\QrCode\Label\Font\NotoSans;
use Endroid\QrCode\RoundBlockSizeMode\RoundBlockSizeModeMargin;
use Endroid\QrCode\Writer\PngWriter;

class Invite extends BaseController
{

    public function index()
    {
        if(!$this->token || $this->userId == '') return ajaxmsg('未登录',500);
        $page   = input("page",1,['trim', FILTER_SANITIZE_NUMBER_INT]);
        $offset = input("offset",20,['trim', FILTER_SANITIZE_NUMBER_INT]);
        $order  = "r.create_time desc";
        $where  = [];
        $where[]= ['r.mid','=', $this->userId];
        //print_r($where);exit;
        $data   = InviteModel::getAll($where,$order,$offset);

        return ajaxmsg('邀请人奖励记录',1,$data);

    }

    /*
      * 需求参数
    */
    public function conf()
    {
        if(!$this->token || $this->userId == '') return ajaxmsg('未登录',500);
        $mid        = $this->userId;
        $user       = Member::get_agents_info($mid);
        $agent_pro  = $user['agent_pro'];
        $agent_rate = Member::agents_back_rate($mid);

        $count      = Db::view('member_invitation_relation r')->view('member m','id','r.invitation_mid = m.id')->where(['r.mid'=>$mid])->count();//邀请用户人数
        $money   = Db::name('agents_back_money')->where(['mid'=>$mid])->sum('affect');//已赚取佣金
        $rande   = $this->rande($mid);
        $url     = sysConfig('app_share_address');
        $url_link= sysConfig('app_url')."/wap/invite/".$rande;//邀请链接
        $qrcode  = $this->generateQrCode($rande);//二维码
        //$share   = sysConfig('share_logo') ? sysConfig('share_logo') :sysConfig('web_site_front_end_logo');
        //$qrcode=$this->view($rande);
        $url = $url ? $url : $url_link;
        $data['qrcode']     = $qrcode;
        $data['code']       = $rande;
        $data['url']        = $url;
        $data['count']      = $count ? $count : 0;
        $data['money']      = $money ? round($money,2) : 0;
        $data['agent_id']   = $user['agent_id'];
        $data['agent_rate'] = $agent_rate;
        $data['agent_pro']  = $agent_pro;
        $data['banner']     = sysConfig('share_logo');//
        //$data['share_logo'] = sysConfig('app_url').getFilePath($share);
        $data['share_title'] = sysConfig('share_title');
        $data['share_content'] = sysConfig('share_content');

        return ajaxmsg('邀请需求参数',1,$data);
    }
    /*
     *生成二维码到前端
     */
    protected function generateQrCode($data, $label = '',$size = 300, $margin = 10)
    {
        $qr = Builder::create()
            ->writer(new PngWriter())
            ->writeroptions([])
            ->data($data)
            ->encoding(new Encoding('UTF-8'))
            ->errorCorrectionLevel(new ErrorCorrectionLevelHigh())
            ->size($size)
            ->margin($margin)
            ->roundBlocksizeMode(new RoundBlockSizeModeMargin());
        if (!empty($label)){
            $qr->labelText($label)
                ->labelFont(new NotoSans(20))
                ->labelAlignment(new LabelAlignmentCenter());
        }
        return $qr->build()->getDataUri();
    }
    /*
     *保存二维码到本地
     */
    protected function savePath($data, $path, $label = '', $size = 300,$margin = 10)
    {
        $gr = Builder::create()
            ->writer(new PngWriter())
            ->writeroptions([])
            ->data($data)
            ->encoding(new Encoding('UTF-8'))
            ->errorCorrectionLevel(new ErrorCorrectionLevelHigh())
            ->size($size)
            ->margin($margin)
            ->roundBlocksizeMode(new RoundBlocksizeModeMargin());
        if (!empty($label)){
            $qr->labelText($label)
                ->labelFont(new NotoSans(20))
                ->labelAlignment(new LabelAlignmentCenter());
        }
        $result = $qr->build();
        $result->saveToFile($path);
        //todo此时已生成图片在指定的路径，根据自身业务对保存到$path的图片处理
    }
    /*
     * 产生id混淆数
     */
    protected function rande($mid){
        return mt_rand(10,99).$mid.mt_rand(100,999);
    }
    
}