<?php
declare (strict_types = 1);

namespace app\apicom\controller;
use app\apicom\model\Slider;
use util\RedisUtil;

use util\NoticeRedis;
class Index extends BaseController
{
    //public $client = $this->request->header();
    
    public function index()
    {
        return ajaxmsg("请求路径错误",0);
    }

    public function getSlider()
    {
        //$client = $this->request->server();
        //print_r($client);return;
        $banner  = Slider::where(['status'=>1])->select()->toArray();
        foreach ($banner as $key=>$val){
            $banner[$key]['image'] = sysConfig('app_url').getFilePath($val['cover']);
        }
        return ajaxmsg('获取成功',1,$banner);
    }
    /*
    获取基础设置
    */
    public function getconf()
    {
        $data['freeopen']     = sysConfig('free_isopen');
        //$data['app_ips']      = @getHostByName($_SERVER['SERVER_NAME']);
        //$data['app_key']      = sysConfig('app_key');
        $data['website']      = sysConfig('web_site_title');//站点名称
        $data['weblogo']      = sysConfig('app_url').getFilePath(sysConfig('web_site_logo'));//站点LOGO
        //$data['free_isopen']  = sysConfig('free_isopen')?:0;//操盘体验板块开关
        //$data['iftrade']      = checkTradeTime();
        //$data['kftime']       = sysConfig('web_site_service_time');
        $data['kfphone']      = sysConfig('web_site_telephone');
        $data['is_smsreg']    = sysConfig('web_reg_code')?:0;//短信注册开关
        $data['is_regist']    = sysConfig('is_reg')?:0;
        $data['is_invita']    = sysConfig('is_recommend')?:0;//邀请注册开关
        $data['app_market']   = sysConfig('app_market')?:0;//APP首屏大盘数据开关
        $data['web_chat_link']= sysConfig('web_chat_link');//客服链接
        $data['copyright']    = sysConfig('web_site_copyright');//版权信息
        $data['web_site_icp'] = sysConfig('web_site_icp');//备案信息
		//$data['news_url']     = sysConfig('news_url');//资讯采集地址
        return ajaxmsg('获取成功',1,$data);
    }
    /*
     * app升级操作
     */
    public function upgrade()
    {
        $data['app_open']            = sysConfig('app_open');//APP开启状态
        $data['app_name']            = sysConfig('app_name');//APP名称
        
        $data['android_power']       = sysConfig('android_power');//安卓强制更新
        $data['android_down']        = sysConfig('android_down');//安卓下载地址
        $data['android_version']     = sysConfig('android_version');//安卓版本
        $data['android_version_name']= sysConfig('android_version_name');//安卓版本CODE（用不到）
        $data['android_description'] = sysConfig('android_description');//版本描述
        
        $data['ios_power']           = sysConfig('ios_power');
        $data['ios_down']            = sysConfig('ios_down');
        $data['ios_version']         = sysConfig('ios_version');
        $data['ios_version_name']    = sysConfig('ios_version_name');//安卓版本CODE（用不到）
        $data['ios_description']     = sysConfig('ios_description');
        if(sysConfig('app_open')){
            return ajaxmsg('app信息',1,$data);
        }else{
            return ajaxmsg('后台暂停APP升级',0);
        }
    }
    /*
    * 获取APP第三方下载链接
    */
    public function download()
    {
        $data['apk_down_url'] = sysConfig('apk_down_url');//安卓端下载链接
        $data['ios_down_url'] = sysConfig('ios_down_url');//苹果端下载链接
        if(sysConfig('app_open')){
            return ajaxmsg('app下载信息',1,$data);
        }else{
            return ajaxmsg('后台已关闭APP下载',0);
        }
    }
    //新浪股票热门行业排行
	public function sinahy()
	{
		$num = input('count', 0, ['trim', FILTER_SANITIZE_NUMBER_INT]);//获取数量
		$res = RedisUtil::getHotIndustrys($num);
		if(!$res) return ajaxmsg('操作失败',0);
        return ajaxmsg('操作成功', 1, $res);
	}
	//新浪股票热门行业分类排行
	public function sinaNodeclass($node,$page,$num)
	{
        //$data = getSinaNodeclass($node,$page,$num);
        $data = RedisUtil::getNodeclassData($node,$page,$num);
        if (!$data) return ajaxmsg('操作失败',0);
        return ajaxmsg('操作成功', 1, $data);
    }
    public function test()
    {
        NoticeRedis::cacheNoticeData(input('id'));
    }
}
