<?php
declare (strict_types = 1);

namespace app\apicom\controller;
use app\apicom\model\Borrow;
use think\facade\Db;
use think\Hook;
/**
 * 配资处理类
 */
class Handle extends BaseController 
{
	/**
	 * 申请配资提交
	 * @param  int $type            类型
	 * @param  int $multiple        倍数
	 * @param  int $deposit_money   保证金
	 * @param  int $borrow_duration 资金使用时间
	 * @param  int $trading_time    交易时间 0 今日 1 下个交易日
	 * @return string               
	 */
	public function applySave()
	{
        $submit          = input('submit',0,['trim', FILTER_SANITIZE_NUMBER_INT]);
        $type            = input('type','',['trim', FILTER_SANITIZE_NUMBER_INT]);
        $multiple        = input('multiple','',['trim', FILTER_SANITIZE_NUMBER_INT]);
        $deposit_money   = input('deposit_money','',['trim', FILTER_SANITIZE_NUMBER_INT]);
        $borrow_duration = input('borrow_duration','',['trim', FILTER_SANITIZE_NUMBER_INT]);
        $trading_time    = input('trading_time','',['trim', FILTER_SANITIZE_NUMBER_INT]);
        $money_range     = explode('|', sysConfig('money_range',''));
        $money_min       = $money_range[0];//最低配资金额
        //$money_max = $money_range[1]; //最高配资金额
        $money_step = $money_range[2]; //配资金额递增幅度
        if(intval($deposit_money) % intval($money_step) != 0){
			return ajaxmsg('您要配资的金额必须是'.$money_step.'的整数倍',0);
        }
        if($deposit_money < intval($money_min)){
			return ajaxmsg('配资金额不能低于'.$money_min.'元',0);
        }
        $Borrow = new Borrow;
        if($type != 4){
            $onecheck = $Borrow->onecheck($this->userId);
            if(!empty($onecheck)){
                return ajaxmsg('=您有配资正在审核中=',0);
            }
            $stockcount = $Borrow->where('member_id',$this->userId)->where('status','in',[1,3])->count();
            if($stockcount > sysConfig('stock_count')) return ajaxmsg('每人最多 '.sysConfig('stock_count').' 个可用配资账号！',0);
        }
        //配资类型  1:按天配资 2:按周配资 3:按月配资 4:免费体验 5:免息配资
        switch ($type){
            case 1:
                $config  = day_config();
                $data['multiple'] = intval($multiple); // 倍率
                if(isset($config['day_rate'][$data['multiple']])){//不在设置的倍率范围内
                    $data['rate'] = $config['day_rate'][$data['multiple']];
                }else{
					return ajaxmsg('参数出错，请联系管理员',0);
                }
                $data['total']      = 1;
                $data['loss_warn']  = $config['day_loss'][0];// 预警线
                $data['loss_close'] = $config['day_loss'][1];// 止损线
                $mmax = count($config['day_position']);
                $data['position'] = isset($config['day_position'][$data['multiple']])?$config['day_position'][$data['multiple']]:$config['day_position'][$mmax];
                break;
            case 2:
                $config  = week_config();
                $data['multiple'] = $multiple; // 倍率
                if(isset($config['week_rate'][$data['multiple']])){//不在设置的倍率范围内
                    $data['rate'] = $config['week_rate'][$data['multiple']];
                }else{
					return ajaxmsg('参数出错，请联系管理员',0);
                }
                $data['total']      = 1;
                $data['loss_warn']  = $config['week_loss'][0];// 预警线
                $data['loss_close'] = $config['week_loss'][1];// 止损线
                $mmax = count($config['week_position']);
                $data['position'] = isset($config['week_position'][$data['multiple']])?$config['week_position'][$data['multiple']]:$config['week_position'][$mmax];
                break;
            case 3:
                $config  = month_config();
                $data['multiple'] = intval($multiple); // 倍率
                if(isset($config['month_rate'][$data['multiple']])){//不在设置的倍率范围内
                    $data['rate'] = $config['month_rate'][$data['multiple']];
                }else{
					return ajaxmsg('参数出错，请联系管理员',0);
                }
                $data['total']      = intval($borrow_duration);
                $data['loss_warn']  = $config['month_loss'][0];// 预警线
                $data['loss_close'] = $config['month_loss'][1];// 止损线
                $mmax = count($config['month_position']);
                $data['position'] = isset($config['month_position'][$data['multiple']])?$config['month_position'][$data['multiple']]:$config['month_position'][$mmax];
                break;
            case 4:
                $check = $Borrow->trycheck($this->userId,4);
                if(!empty($check)){
					return ajaxmsg('您只能试用一次',0);
                }
                $config  = free_config();
                $data['loss_warn']    = $config['free_loss'][0];// 预警线 这里借用了免费配资的避免为空 其实无意义
                $data['loss_close']   = $config['free_loss'][1];// 止损线 这里借用了免费配资的避免为空 其实无意义
                $data['position']     = $config['day_position'][1];
                $deposit_money        = 1;
                $borrow_duration      = 2;
                $data['rate']         = 0;
                $data['multiple']     = 1; // 倍率
                $data['total']        = 1;
                $data['borrow_money'] = 200000;
                break;
            case 5:
                $config   = free_config();
                $multiple = $config['free_set'][0];
                $borrow_duration    = $config['free_set'][1];
                $data['rate']       = 0;
                $data['multiple']   = intval($multiple); // 倍率
                $data['total']      = 1;
                $data['loss_warn']  = $config['free_loss'][0]; // 预警线
                $data['loss_close'] = $config['free_loss'][1];// 止损线
                $mmax = count($config['day_position']);
                $data['position'] = isset($config['day_position'][$data['multiple']])?$config['day_position'][$data['multiple']]:$config['day_position'][$mmax];
                break;
            default:
				return ajaxmsg('类型出错，请重新输入！',0);
        }
        $data['deposit_money'] = $deposit_money;
        if($type!=4){
            $money_max = $money_range[1]*$multiple; //最高配资金额
            $data['borrow_money'] = $data['deposit_money'] * $data['multiple'];// 配资金额
        }else{
            $money_max = $money_range[1]; //最高配资金额
        }
        $data['init_money'] = (int)$data['borrow_money'] + (int)$data['deposit_money'];// 初始资金金额
        $money = money_convert($data['init_money']);//bcdiv(strval($data['init_money']),'1',2);
        if($money > intval($money_max)){
			return ajaxmsg('最多只能配资'.$money_max.'元',0);
        }
        $data['order_id']            = generate_rand_str(15, 3);
        $data['trading_time']        = intval($trading_time);
        $data['type']                = $type;
        $data['member_id']           = $this->userId;
        $data['borrow_duration']     = $borrow_duration; // 操盘期限
		$data['total']               = $type == 3 ? $data['borrow_duration'] : 1;
		$data['sort_order']          = 1;
        if($submit == 1){
            // 验证
            $res = $this->validate($data,'Borrow.create');
    		if(!$res) return ajaxmsg($res,0);
    		$result = $Borrow->createStock($data);
    		if(!$result['status']){
    			return ajaxmsg($result['msg'],0);
    		}else{
    			return ajaxmsg($result['msg'],1);
    		}
        }
        
        return ajaxmsg('操作成功',1,$data);
	}
}

?>