<?php
declare (strict_types = 1);

namespace app\apicom\controller;
use app\apicom\model\Column as ColumnModel;
use app\apicom\model\Document as DocumentModel;
use think\facade\Db;

/**
 * 文档控制器
 * @package app\apicom\home
 */
class Document extends BaseController
{
    /**
     * 文档详情页
     * @param null $id 文档id
     * @param string $model 独立模型id
     * @author 路人甲乙
     * @return mixed
     */
    public function detail($id = null, $model = '')
    {
        $id    = input('id', '', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $model = input('model', '', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        if (!$id || !$model) return ajaxmsg("缺少参数",0);
        // 获取文章内容
        $info = DocumentModel::getOne($id, $model);
		return ajaxmsg('获取成功',1,$info);
    }

  
}