<?php
declare (strict_types = 1);

namespace app\apicom\controller;
use app\apicom\model\Column as ColumnModel;
use app\apicom\model\Document as DocumentModel;
use think\facade\Db;
use think\Request;
use util\Tree;
/**
 * 前台栏目文档列表控制器
 */
class Column extends BaseController
{
    /**
     * 栏目文章列表
     * @param null $id 栏目id
     * @return mixed
     */
    public function index()
    {
        $id = input('id', '', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        if (!$id) return ajaxmsg("缺少参数",0);
		$prefix = sysConfig("database.prefix");
        $map = [
            'status' => 1,
            'id'     => $id
        ];
        $page   = input("page",1);
        $offset = ($page-1) * 20;
        $column = ColumnModel::where($map)->find();
        if (!$column) return ajaxmsg("该栏目不存在",0);
        $model  = ColumnModel::where('id', $column['model'])->find();
        //print_r($model);exit;
        $cid_all   = ColumnModel::getChildsId($id);
        $cid_all[] = (int)$id;
        $map = [
            'd.trash'  => 0,
            'd.status' => 1,
        ];
		$result = DocumentModel::alias('d')->where($map)->whereIn('d.cid',$cid_all)->order('d.id desc')->paginate($offset, false, ['query' => request()->param()]);
        return ajaxmsg('获取成功',1,$result);
    }
}