<?php
namespace app\admin\validate;

use think\Validate;

class Stock extends Validate
{

    protected $rule = [
        'code'    => 'require',
        'title'   => 'require',
        'market'  => 'require',
        'pinyin'  => 'require',
    ];

    protected $message = [
        'code.require'   => '股票代码不能为空',
        'title.require'  => '股票名称不能为空',
        'pinyin.require' => '股票简拼不能为空',
        'market.require' => '市场代码不能为空',
    ];

    protected $scene = [
        'saveStock'    => ['code', 'title', 'market', 'pinyin'],
    ];

}
