<?php
namespace app\admin\validate;

use think\Validate;

class Bank extends Validate
{

    protected $rule = [
        'bank_name'           => 'require',
        'type'                => 'require',
        'open_bank'           => 'require',
        'card'                => 'require',
    ];

    protected $message = [
        'bank_name.require'           => '请输入收款银行',
        'type.require'                => '请选择银行类型',
        'open_bank.require'           => '请填写开户支行名称',
        'card.require'                => '请填写银行卡号',
    ];

    /**
     * 新增收款银行卡信息的验证
     * @return UserBankCard
     */
    //定义验证场景
    protected $scene = [
        'create'      => ['bank_name', 'type', 'open_bank','card'],
    ];
}
