<?php
namespace app\agent\validate;

use think\Validate;

/**
 * 用户验证器
 * @package app\agent\validate
 */
class AgentUser extends Validate
{
    //定义验证规则
    protected $rule = [
        'username|用户名' => 'require|alphaNum|unique:admin_user',
        'nickname|角色名' => 'require',
        'role|角色'       => 'require',
        'email|邮箱'      => 'email|unique:admin_user',
        'password|密码'   => 'require|length:6,20',
        'confirm|重复密码'=> 'require|confirm:password',
        'mobile|手机号'   => 'regex:^1\d{10}|unique:admin_user',
        'captcha|验证码'  => 'require',
    ];

    //定义验证提示
    protected $message = [
        'username.require' => '请输入用户名',
        'nickname.require' => '请输入角色名',
        'email.require'    => '邮箱不能为空',
        'email.email'      => '邮箱格式不正确',
        'email.unique'     => '该邮箱已存在',
        'password.require' => '密码不能为空',
        'password.length'  => '密码长度6-20位',
        'confirm.require'  => '请输入确认密码',
        'confirm.confirm'  => '您两次输入的密码不一致',
        'mobile.regex'     => '手机号不正确',
        'captcha.require'  => '验证码不能为空',
    ];

    //定义验证场景
    protected $scene = [
        //更新
        'update'  => ['email', 'password' => 'length:6,20', 'mobile', 'role'],
        //登录
        'signin'  => ['username'=>'require', 'password'=>'require', 'captcha'=>'require'],
        //新建
        'create'  => ['username', 'mobile', 'nickname', 'password', 'confirm'],
        //编辑
        'edit'    => ['username', 'mobile', 'nickname'],
    ];
}
