<?php
declare (strict_types = 1);

namespace app\admin\controller;

use think\facade\Db;
use util\RedisUtil;

class Report extends AdminBase
{
    public function index()
    {
        //会员数量统计
        $data[] = self::MemberReport();
        //充值提现统计
        $data[] = self::MoneyReport();
        //股票持仓统计
        $data[] = self::StocksReport();
        //配资管理统计
        $data[] = self::BorrowReport();
        return ajaxmsg('操作成功',200,$data);
    }
    //会员数量统计
    public function MemberReport()
    {
        $data = [
            'title' => '会员数量统计',
            'infos' => [
                [ 'name'  => '注册会员总数', 'value' => Db::name('member')->where(['is_del'=>0])->count() ],
                [ 'name'  => '一级代理总数', 'value' => Db::name('member')->where(['status'=>1,'agent_id'=>2])->count() ],
                [ 'name'  => '二级代理总数', 'value' => Db::name('member')->where(['status'=>1,'agent_id'=>3])->count() ],
                [ 'name'  => '三级代理总数', 'value' => Db::name('member')->where(['status'=>1,'agent_id'=>4])->count() ],
                [ 'name'  => '当前代理总数', 'value' => Db::name('member')->where('agent_id','>',0)->where('status',1)->count() ]
            ]
        ];
        return $data ?? [];
    }
    //充值提现统计
    public function MoneyReport()
    {
        $data = [
            'title' => '充值提现统计',
            'infos' => [
                [ 'name'  => '累计充值总额', 'value' => money_convert(Db::name('money_recharge')->where('status','1')->sum('money')) ],
                [ 'name'  => '今日充值金额', 'value' => money_convert(Db::name('money_recharge')->where('status','1')->whereDay('create_time')->sum('money')) ],
                [ 'name'  => '累计提现总额', 'value' => money_convert(Db::name('money_withdraw')->where('status','1')->sum('money'))],
                [ 'name'  => '今日提现金额', 'value' => money_convert(Db::name('money_withdraw')->where('status','1')->whereDay('create_time')->sum('money')) ],
            ]
        ];
        return $data ?? [];
    }
    //股票持仓统计
    public function StocksReport()
    {
        $position = self::position();
        $data = [
            'title' => '股票持仓统计',
            'infos' => [
                [ 'name'  => '持仓股票总额', 'value' => round($position['Total'],2) ],
                [ 'name'  => '今日委托金额', 'value' => money_convert(Db::name('stock_trust')->whereDay('trust_date')->sum('amount')) ],
                [ 'name'  => '今日委托总数', 'value' => Db::name('stock_trust')->whereDay('trust_date')->count()],
                [ 'name'  => '今日成交金额', 'value' => money_convert(Db::name('stock_deal_stock')->whereDay('deal_date')->where('status','<>','0')->sum('amount')) ],
                [ 'name'  => '今日成交总数', 'value' => Db::name('stock_deal_stock')->whereDay('deal_date')->where('status','<>','0')->count() ],
                [ 'name'  => '持仓盈亏总额', 'value' => round($position['Profit'],2) ],
            ]
        ];
        return $data ?? [];
    }
    //配资管理统计
    public function BorrowReport()
    {
        $data = [
            'title' => '配资管理统计',
            'infos' => [
                [ 'name'  => '累计总管理费', 'value' => money_convert(Db::name('stock_borrow')->where('status','>=',1)->sum('borrow_interest')) ],
                [ 'name'  => '累计返佣金额', 'value' => round(Db::name('agents_back_money')->sum('affect'), 2) ],
                [ 'name'  => '保证金总金额', 'value' => money_convert(Db::name('stock_borrow')->where(['status'=>1])->sum('deposit_money')) ],
                [ 'name'  => '总追加保证金', 'value' => money_convert(Db::name('stock_addmoney')->where(['status'=>1])->sum('money')) ],
                [ 'name'  => '累计提盈总额', 'value' => round(Db::name('stock_drawprofit ')->where(['status'=>1])->sum('money'),2) ],
                [ 'name'  => '累计操盘总额', 'value' => money_convert(Db::name('money')->where('status=1')->sum('operate_account')) ],
            ]
        ];
        return $data ?? [];
    }
    
    /*********************************************************************/
    public function position()
    {
        //持仓总额
        $Total = $Profit = 0;
        $Stock = Db::name('stock_position')->where('stock_count','>',0)->where(['buying'=>0])->select();
        foreach ($Stock as $k=>$v){
            //查询股票最新行情
            $Qdata   = RedisUtil::getQuotationData($v["gupiao_code"],$v["market"],true);
            $Price   = $Qdata['Price'] ?: 0;
            //持仓总额
            $Total  += ($v['stock_count']*$Price);
            //盈亏总额
            $Profit += round(($Price-self::calculate($v["gupiao_code"],'average'))*$v['stock_count'], 2);
        }
        return ['Total'=>$Total,'Profit'=>$Profit];
    }
    public function calculate($code,$variable)
    {
        if(!$code || !$variable) return 0;
        switch ($variable) {
            case 'price':
                $order = Db::name('stock_delivery_order')->where(['gupiao_code' => $code,'status' => 1,'business_name' => '证券买入']);
                $amount = $order->sum('liquidation_amount');
                $volume = $order->sum('volume');
                $result =  bcdiv(strval($amount),strval($volume),3);
                break;
             case 'average':
                $order = Db::name('stock_delivery_order')->where(['gupiao_code' => $code,'status' => 1,'business_name' => '证券买入']);
                $amount = $order->sum('residual_quantity');
                $volume = $order->sum('volume');
                $result =  bcdiv(strval($amount),strval($volume),3);
                break;
            default:
                $result = 0;
                break;
        }
        return $result;
    }
}