<?php
declare (strict_types = 1);

namespace app\agent\controller;

use app\admin\model\Order as OrderModel;
use app\apicom\model\Borrow as BorrowModel;

use think\facade\Db;
use util\RedisUtil;

class Order extends AgentBase
{
    /*
     * 获取订单列表
     */
     
    public function getOrderList()
    {
        $path   = input('path','');
        $name   = input('name','');
        $code   = input('code',''  , ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $subid  = input('subid','' , ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $mobile = input('mobile','', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $offset = input('pageSize',20, ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $order  = 'id desc';
        $where[] = ['m.agent_far' ,'=', $this->agentId];
        if(!$path) return ajaxmsg('缺少参数',0);
        if(!empty($name))  $where[] = ['m.name','=', $name];
        if(!empty($code))  $where[] = ['s.gupiao_code','=', $code];
        if(!empty($subid)) $where[] = ['sub.sub_account','=', $subid];
        if(!empty($mobile))$where[] = ['m.mobile','=', $mobile];
        
        $data_list = OrderModel::getAllList($path,$where,$order,$offset);
        if(!$data_list) return ajaxmsg('没有数据',0);
        return ajaxmsg('操作成功',200,$data_list);
    }
    /*
     * 修改新股申购
     */
    public function doIpoEdit()
    {
        $id     = input('id','', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $status = input('status','');
		$res    = Db::name('stock_trust_ipo')->where(['id'=>$id,'status'=>'申购中'])->save(['status'=> $status]);
        //这里要做委托和撤单判断
        if ($res) {
            return ajaxmsg('操作成功',200);
        } else {
            return ajaxmsg('操作失败',0);
        }
    }
    /*
     * 强制平仓
     */
    public function handleClose()
    {
        if(!checkTradeTime()) return ajaxmsg('非交易时间',0);

        $data  = [
            "subid"  => input('sub_id',''),//子账户ID,
    	    "code"   => input('gupiao_code'  ,''),//股票代码
    	    "name"   => input('gupiao_name'  ,''),//股票名称
    	    "market" => input('market',''),//交易所代码
    	    "count"  => input('canbuy_count' , 0),//买卖数量
    	    'model'  => input('model' , 2),//1：是委托状态
        ];
        $price = input('now_price',0);//手动设置价格

        $res = BorrowModel::saveSell($data,$sys=1,$price);
        //return $res;
        if(isset($res['status'])){
            if(!$res['status']) return ajaxmsg($res['message'],0);
            return ajaxmsg('强平操作成功！',200);
        }else{
            return ajaxmsg('操作失败！',0);
        }
    }
}