<?php
declare (strict_types = 1);

namespace app\agent\controller;
use app\apicom\model\Money   as MoneyModel;
use app\apicom\model\Member  as MemberModel;
use app\apicom\model\Record  as RecordModel;
use app\apicom\model\Recharge;
use app\apicom\model\Withdraw;

use app\admin\model\Money   as AdminBank;
use think\facade\Db;

class Money extends AgentBase
{
    /* 
     * 获取资金明细
     */
    public function getMoneyRecord()
    {
        $name   = input('name', '');
        $mobile = input('mobile','', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $offset = input('pageSize',20, ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $order  = 'create_time desc';
        if(!empty($name))   $where[] = ['m.name' ,'=', $name];
        if(!empty($mobile)) $where[] = ['m.mobile' ,'=', $mobile];
        $where[] = ['m.is_del' ,'=', 0];
        $where[] = ['m.agent_far' ,'=', $this->agentId];
        $res = RecordModel::getAll($where,$order,$offset);
        if(!$res) return ajaxmsg('没有数据',0);
        return ajaxmsg('操作成功',200,$res);
    }
    
}