<?php
declare (strict_types = 1);

namespace app\agent\controller;

use app\apicom\model\Member  as MemberModel;
use app\apicom\model\Record  as RecordModel;
use app\apicom\model\Recharge;
use app\apicom\model\Withdraw;
use think\facade\Db;

class Member extends AgentBase
{
    public function index()
    {
        return '您好！';
    }
    /*
     * 获取会员列表
     */
    public function getList()
    {
        $name   = input('name', '');
        $mobile = input('mobile','', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $offset = input('pageSize',20, ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $agent  = $this->agentId;
        $order  = 'id desc';
        if(!empty($name))   $where[] = ['a.name'  ,'=', $name];
        if(!empty($mobile)) $where[] = ['a.mobile','=', $mobile];
        if(!empty($agent))  $where[] = ['a.agent_far','=', $agent];
        $where[]   = ['a.is_del' ,'=', 0];
    	$data_list = MemberModel::view('member a')
        	->view('money b','account,freeze,operate_account,bond_account','a.id=b.mid')
        	->where($where)
        	->order($order)
        	->paginate($offset, false, ['query' => request()->param()]);
    	if(!$data_list) return ajaxmsg('没有数据',0);
        
        return ajaxmsg('操作成功',200,$data_list);
    }
    /*
     * 禁用会员
     */
    public function doDisable()
    {
        $id     = input('id','', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $status = input('status','', ['trim', FILTER_SANITIZE_NUMBER_INT]);
		if($status == '') return ajaxmsg('缺少参数',0);
		$where[] = ['id'  ,'=', $id];
		$where[] = ['agent_far'  ,'=', $this->agentId];
		$res = MemberModel::where($where)->save(['status'=> $status]);
        if ($res) {
            return ajaxmsg('操作成功',200);
        } else {
            return ajaxmsg('操作失败',0);
        }
    }
    /*
     * 新增会员
     */
    public function addMember()
    {
        $data = input();
		$data['agent_far']= $this->agentId;
		//print_r($data);exit;
		// 验证数据
		$result = $this->validate($data, 'Member.create');
		if ($result !== true) return ajaxmsg($result,0);
		
		if (empty($data['mobile'])) 
		    return ajaxmsg('请输入您的手机号！',0);
		$userExist = MemberModel::where('mobile|name', '=', $data['mobile'])->column('mobile', 'id');
        if ($userExist) 
            return ajaxmsg('该手机号已经注册',0);
		if (!in_array(strlen($data['mobile']), [8, 9, 11])) 
		    return ajaxmsg('您输入的手机号码有误!',0);
		$res = MemberModel::saveData($data);
        if ($res) {
            return ajaxmsg('操作成功',200);
        } else {
            return ajaxmsg('操作失败',0);
        }
    }
    /*
     * 编辑用户
     */
    public function editMember()
    {
        $data = input();
        $data['agent_id'] = $data['agent_id'];
        $data['status']   = $data['status'];
        $data['agent_far']= $this->agentId;
        if(isset($data['agent_far'][0])){
            $data['agent_far'] = $data['agent_pro'] = $data['agent_far'][0];
        }else{
            $data['agent_far'] = $data['agent_pro'] = 0;
        }
        if($data['passwd']) $data['passwd'] = password_hash($data['passwd'], PASSWORD_DEFAULT);
        if($data['paywd'] ) $data['paywd']  = password_hash($data['paywd'] , PASSWORD_DEFAULT);
        if (empty($data['id'])) return ajaxmsg('缺少ID参数！',0);
        if (empty($data['passwd'])) unset($data['passwd']);
        if (empty($data['paywd']))  unset($data['paywd']);
        //print_r($data);exit;
		$res = MemberModel::strict(false)->where(['id'=>$data['id']])->save($data);
		if ($res) {
            return ajaxmsg('操作成功',200);
        } else {
            return ajaxmsg('操作失败',0);
        }
    }

    
}
