<?php
declare (strict_types = 1);

namespace app\agent\controller;
use app\agent\model\Order  as OrderModel;
use app\agent\model\Borrow as BorrowModel;
use think\facade\Db;
use think\facade\App;
use think\facade\Config;

class Index extends AgentBase
{
    public function index()
    {
        $data = [];
        //下级配资总数
        $borrows = strval(self::getStockBorrow($this->agentId));
        //下级持仓总数
        $pos_all = strval(self::getPosition($this->agentId));
        //累计充值总额
        //$r_total = money_convert(Db::name('money_recharge')->where(['status'=>1])->sum('money'));
        //累计提现总额
        //$w_total = money_convert(Db::name('money_withdraw')->where(['status'=>1])->sum('money'));
        //累计操盘余额
        //$account = money_convert(Db::name('money')->where('status=1')->sum('operate_account'));
        
        
        //按天配资
        $dayCount   = self::getStockBorrow($this->agentId,'1');
        //按周配资
        $weekCount  = self::getStockBorrow($this->agentId,'2');
        //按月配资
        $monthCount = self::getStockBorrow($this->agentId,'3');
        //免费体验
        $tryCount   = self::getStockBorrow($this->agentId,'4');
        //免息配资
        $freeCount  = self::getStockBorrow($this->agentId,'5');
        //模拟操盘
        $mockCount  = self::getStockBorrow($this->agentId,'6');
        
        //当日注册会员
        $m_today = strval(Db::name('member')->where(['is_del'=>0,'agent_far'=>$this->agentId])->whereDay('create_time')->count());
        //昨日注册会员
        $m_ysday = strval(Db::name('member')->where(['is_del'=>0,'agent_far'=>$this->agentId])->whereDay('create_time','yesterday')->count());
        //本周注册会员
        $m_weeks = strval(Db::name('member')->where(['is_del'=>0,'agent_far'=>$this->agentId])->whereWeek('create_time')->count());
        //本月注册会员
        $m_month = strval(Db::name('member')->where(['is_del'=>0,'agent_far'=>$this->agentId])->whereMonth('create_time')->count());
        //今年注册会员
        $m_years = strval(Db::name('member')->where(['is_del'=>0,'agent_far'=>$this->agentId])->whereYear('create_time')->count());
        //注册会员总数
        $m_total = strval(Db::name('member')->where(['is_del'=>0,'agent_far'=>$this->agentId])->count());
        
        $data['rowlist'][] = ['name'=>'下级会员总数','value'=>$m_total,'icon'=>'el-icon-user-solid grid-con-1'];
        $data['rowlist'][] = ['name'=>'下级配资总数','value'=>$borrows,'icon'=>'el-icon-s-marketing grid-con-2'];
        $data['rowlist'][] = ['name'=>'下级持仓总数','value'=>$pos_all,'icon'=>'el-icon-s-custom grid-con-3'];
        
        //$data['rowlist'][] = ['name'=>'累计充值总额','value'=>$r_total,'icon'=>'el-icon-s-finance grid-con-1'];
        //$data['rowlist'][] = ['name'=>'累计提现总额','value'=>$w_total,'icon'=>'el-icon-wallet grid-con-2'];
        //$data['rowlist'][] = ['name'=>'累计操盘余额','value'=>$account,'icon'=>'el-icon-money grid-con-3'];

        $data['borrow']['labels'] = ["按天配资","按周配资","按月配资","免息配资"];
        $data['borrow']['datasets'][] = [
            'data'  => [$dayCount,$weekCount,$monthCount,$freeCount]
        ];
        
        $data['member']['labels'] = ["当日注册","昨日注册","本周注册","本月注册","今年注册"];
        $data['member']['datasets'][] = [
            'label' => '注册会员',
            'data'  => [$m_today,$m_ysday,$m_weeks,$m_month,$m_years]
        ];
        
        return ajaxmsg('操作成功',200,$data);
    }
    public function welcome()
    {
        return ajaxmsg('操作成功',200,$this->request->server());
    }
    //获取下级配资列表
    public function getStockBorrow($agent,$type = '')
    {
        
        $where[] = ['m.agent_far' ,'=', $agent];
        //$where[] = ['b.status','=','1'];
        $borrows = BorrowModel::getBorrowCount($where);
        //print_r($borrows);exit;
        return $borrows ? $borrows : 0;
    }
    //获取下级持仓列表
    public function getPosition($agent)
    {
        $where[] = ['m.agent_far' ,'=', $agent];
        $position = OrderModel::getOrderCount('position',$where);
        return $position ? $position : 0;
    }
}
