<?php
namespace app\admin\validate;

use think\Validate;

class Risk extends Validate
{
    //定义验证规则
    protected $rule = [
        'stockjobber|证券公司' => 'require',
        'lid|证券账户'         => 'require',
        'user|交易账户'        => 'require',
        'pwd|交易密码'         => 'require',
    ];

    //定义验证提示
    protected $message = [
        'stockjobber.require'  => '请输入证券公司',
        'lid.require'          => '请输入证券账户',
        'user.require'         => '请输入交易账户',
        'pwd.regex'            => '请输入账户密码',
    ];

    //定义验证场景
    protected $scene = [
        'create'      => ['stockjobber','lid', 'pwd', 'user'],
    ];
}
