<?php

namespace app\admin\model;
use think\Model;
use think\facade\Db;
use util\RedisUtil;
/**
 * 后台股票列表模型
 * @package app\admin\model
 */
class StockList extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $name = 'stock_list';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;
    
    public static function intStockList($data)
    {
        if(!$data) return false;
        $list = [];
        foreach ($data as $key => $item) {
            $list[$key]['title']  = $item['name'];
            $list[$key]['market'] = $item['market'];
            $list[$key]['code']   = $item['code'];
            $list[$key]['pinyin'] = $item['pinyin'];
            $list[$key]['status'] = 1;
            $list[$key]['add_time']    = time();
            $list[$key]['edit_time']   = time();
            $list[$key]['target_uid']  = 1;
            $list[$key]['target_name'] = 'admin';
        }
        Db::startTrans();
        $ret = Db::execute('truncate '. config('database.connections.mysql.prefix').'stock_list');
        try {
            $res = self::insertAll($list);
            if($res){
                Db::commit();
		        return true;
            }
        } catch (Exception $e) {
            Db::rollback();
            return false;
        }
    }
}