<?php

namespace app\admin\model;

use app\admin\model\Attachment;
use think\Model;
use think\facade\Db;

/**
 * 后台用户模型
 * @package app\admin\model
 */
class Slider extends Model
{
    // 设置当前模型对应的完整数据表名称
    protected $name = 'cms_slider';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;
    
    public static function getList($map=[],$order='',$offset=20)
    {
        $data_list = self::where($map)
            ->order($order)
            ->paginate($offset, false, ['query' => request()->param()])
            ->each( function($item, $key){
                $item['img_url'] = sysConfig('app_url').getFilePath($item['cover']);
            });
        return $data_list;
    }
    /*
     * 保存数据
     */
    public static function saveData($data)
    {
        $exist = Attachment::where(['name' => $data['name']])->find();
        if($exist){
            $data['cover'] = $exist['id'];
            $add = self::create($data);
            if($add) return true;
        }
        return false;
    }
}