<?php

namespace app\admin\model;
use app\apicom\model\StockPosition;
use think\Model;
use think\facade\Db;
use util\RedisUtil;
/**
 * 后台用户模型
 * @package app\admin\model
 */
class Order extends Model
{
    // 交割订单状态获取器
    public static function getStatusName($value)
    {
        $status = ['0'=>'未交割','1'=>'已交割'];
        return $status[$value];
    }
    /*
     * 获取 持仓*委托*成交*撤单*交割 列表
     */
    public static function getAllList($path,$map=[],$order='',$offset=20)
    {
        switch ($path) {
            case 'position':
                $data_list = Db::view('stock_position s',true)
                    ->view('stock_subaccount sub', 'sub_account', 'sub.id=s.sub_id', 'left')
                    ->view('member m', 'mobile,name', 'm.id=sub.uid', 'left')
        		    ->where($map)
        		    ->where('s.stock_count','>',0)
        		    ->order($order)
        		    ->paginate($offset, false, ['query' => request()->param()])
        		    ->each( function($item, $key){
                        return self::getMarketValue($item);
                    });
                break;
            case 'trust':
                $data_list = Db::view('stock_trust s',true)
                    ->view('stock_subaccount sub', 'sub_account', 'sub.id=s.sub_id', 'left')
                    ->view('member m', 'mobile,name', 'm.id=sub.uid', 'left')
        		    ->where('s.status','<>','已撤')
        		    ->where($map)
        		    ->order($order)
        		    ->paginate($offset, false, ['query' => request()->param()])
        		    ->each( function($item, $key){
                        $item['trust_count'] = intval($item['trust_count']);
                        $item['add_time']    = date('Y-m-d H:i:s' ,$item['add_time']);
                        return $item;
                    });
                break;
            case 'deal':
                $data_list = Db::view('stock_deal_stock s',true)
                    ->view('stock_subaccount sub', 'sub_account', 'sub.id=s.sub_id', 'left')
                    ->view('member m', 'mobile,name', 'm.id=sub.uid', 'left')
        		    ->where($map)
        		    ->order($order)
        		    ->paginate($offset, false, ['query' => request()->param()])
        		    ->each( function($item, $key){
                        $item['trust_count'] = intval($item['trust_count']);
                        return $item;
                    });
                break;
            case 'cancel':
                $data_list = Db::view('stock_trust s',true)
                    ->view('stock_subaccount sub', 'sub_account', 'sub.id=s.sub_id', 'left')
                    ->view('member m', 'mobile,name', 'm.id=sub.uid', 'left')
        		    ->where('s.status','=','已撤')
        		    ->where($map)
        		    ->order($order)
        		    ->paginate($offset, false, ['query' => request()->param()])
        		    ->each( function($item, $key){
                        $item['trust_count'] = intval($item['trust_count']);
                        $item['add_time']    = date('Y-m-d H:i:s' ,$item['add_time']);
                        return $item;
                    });
                break;
            case 'delivery':
                $data_list = Db::view('stock_delivery_order s',true)
                    ->view('stock_subaccount sub', 'sub_account', 'sub.id=s.sub_id', 'left')
                    ->view('member m', 'mobile,name', 'm.id=sub.uid', 'left')
        		    ->where($map)
        		    ->order($order)
        		    ->paginate($offset, false, ['query' => request()->param()])
        		    ->each( function($item, $key){
                        $item['status_n'] = self::getStatusName($item['status']);
                        //$item['add_time']    = date('Y-m-d H:i:s' ,$item['add_time']);
                        return $item;
                    });
                break;
            case 'ipolist':
                $data_list = Db::view('stock_trust_ipo s',true)
                   ->view('stock_subaccount sub', 'sub_account', 'sub.id=s.sub_id', 'left')
                    ->view('member m', 'mobile,name', 'm.id=sub.uid', 'left')
        		    ->where('s.status','<>','')
        		    ->where($map)
        		    ->order($order)
        		    ->paginate($offset, false, ['query' => request()->param()])
        		    ->each( function($item, $key){
                        $item['trust_count'] = intval($item['trust_count']);
                        $item['add_time']    = date('Y-m-d H:i:s' ,$item['add_time']);
                        return $item;
                    });
                break;
            default:
                $data_list = [];
                break;
        }
        return $data_list;
    }
    public static function getMarketValue($item=[])    {        //查询股票最新行情
        $Qdata = RedisUtil::getQuotationData($item["gupiao_code"],$item["market"],true);
        //提取当前价格
        $item['now_price']         = $Qdata['Price'] ?: 0;
        //市值 = 当前价格*数量
        $item['market_value']      = round($item['now_price']*$item['stock_count'], 2);
        //参考成本价
        $item['ck_price']          = StockPosition::calculate($item['sub_id'],$item["gupiao_code"],'price');
        //买入均价
        $item['buy_average_price'] = StockPosition::calculate($item['sub_id'],$item["gupiao_code"],'average');
        //参考盈亏
        $item['ck_profit']         = $item['stock_count'] > 0 ? bcmul(strval($item['now_price']-$item['buy_average_price']),strval($item['stock_count']),2) : 0;
        //盈亏比例
        $item['profit_rate']       = $item['stock_count'] > 0 ? bcdiv(strval($item['ck_profit']),strval($item['buy_average_price']*$item['stock_count']*100),2) : 0;
        //当天可卖数量计算
        $item['canbuy_count']      = StockPosition::getCanbuyCount($item['sub_id'],$item["gupiao_code"]);
        return $item;
    }}