<?php

namespace app\admin\model;

use think\Model;
use think\facade\Db;

/**
 * 后台用户模型
 * @package app\admin\model
 */
class AdminUser extends Model
{
     // 设置当前模型对应的完整数据表名称
    protected $name = 'admin_user';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;
    
    public static function getList($map=[],$order='',$offset=20)
    {
        $data_list = self::where($map)
            ->order($order)
            ->paginate($offset, false, ['query' => request()->param()])
            ->each( function($item, $key){
                $item['last_time'] = date('Y-m-d H:i:s',$item['last_time']);
            });
        return $data_list;
    }
    /**
     * 保存注册数据
     * @param  [type] $data [description]
     */
    public static function saveData($data)
    {
        $sdata['mobile']   = $data['mobile'];
        $sdata['username'] = $data['username'];
        $sdata['nickname'] = $data['nickname'];
        $sdata['password'] = password_hash($data['password'], PASSWORD_DEFAULT);
        $sdata['pid']      = 0;
        $sdata['status']   = 1;
        $sdata['create_time'] = time();
        $sdata['last_login_ip'] = getClientIp();
        if(self::create($sdata)) return true;
        return false;
    }
}