<?php

namespace app\admin\model;

use think\Model;
use think\facade\Db;
use util\SystemRedis;
/**
 * 后台用户模型
 * @package app\admin\model
 */
class AdminConfig extends Model
{
     // 设置当前模型对应的完整数据表名称
    protected $name = 'admin_config';

    // 自动写入时间戳
    protected $autoWriteTimestamp = true;
    
    public static function getAdminConfig($group)
    {
        $data_list = self::where(['group'=>$group, 'status'=>1])
            ->order('sort asc')
            ->select()
            ->each( function($item, $key){
                //return $item;
            });
        SystemRedis::cacheConfig();
        return $data_list;
    }
}