<?php
declare (strict_types = 1);

namespace app\admin\controller;
use app\admin\model\Slider as SliderModel;
use think\facade\Db;

/**
 * 文档控制器
 * @package app\apicom\home
 */
class Slider extends AdminBase
{
    /*
     * 获取轮播列表
     */
    public function getList()
    {
        $title  = input('title', '');
        $offset = input('pageSize',20, ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $order  = 'id desc';
        $where  = [];
        if(!empty($title))  $where[] = ['title','like', "%{$title}%"];
        $res = SliderModel::getList($where,$order,$offset);
        if($res){
            return ajaxmsg('操作成功',200, $res); 
        }else {
            return ajaxmsg('操作失败',0);
        }
    }
    /*
     * 启用/禁用 状态
     */
    public function doDisable()
    {
        $id     = input('id','', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $status = input('status','', ['trim', FILTER_SANITIZE_NUMBER_INT]);
		$res = SliderModel::where('id', $id)->save(['status'=> $status]);
        if ($res) {
            return ajaxmsg('操作成功',200);
        } else {
            return ajaxmsg('操作失败',0);
        }
    }
    /*
     * 删除轮播
     */
    public function delSlider()
    {
        $id  = input('id','', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $sli = SliderModel::where('id', $id)->find();
        if(empty($sli)) return ajaxmsg('查询失败',0);
		Db::startTrans();
		$res = SliderModel::where('id', $id)->delete();
        if ($res) {
            Db::commit();
            return ajaxmsg('操作成功',200);
        } else {
            Db::rollback();
            return ajaxmsg('操作失败',0);
        }
    }
    /**
     * 轮播详情页
     */
    public function getDetail()
    {
        $id    = input('id', '', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        if (!$id) return ajaxmsg("缺少参数",0);
        // 获取文章内容
        $info = SliderModel::where(['id'=> $id,'status' => 1])->find();
        $info['img_url'] = sysConfig('app_url').getFilePath($info['cover']);
		if(!$info) return ajaxmsg('查询失败',0);
		return ajaxmsg('获取成功',200,$info);
    }
    /*
     * 新增广告
     */
    public function addSlider()
    {
        $data = input();
		$data['create_time'] = time();
		// 验证数据
		$result = $this->validate($data, 'Slider.create');
		if ($result !== true) return ajaxmsg($result,0);
		//dump($data);exit;
		$res = SliderModel::saveData($data);
        if ($res) {
            return ajaxmsg('操作成功',200);
        } else {
            return ajaxmsg('操作失败',0);
        }
    }
}