<?php
declare (strict_types = 1);

namespace app\admin\controller;
use app\admin\model\AdminConfig;
use util\SystemRedis;
use think\facade\Db;

class Setting extends AdminBase
{
    /*
     * 获取网站设置列表
     */
     
    public function getConfigs()
    {
        $group = input('group','');
        if(!$group) return ajaxmsg('缺少参数',0);
        $data_list = AdminConfig::getAdminConfig($group);
        if(!$data_list) return ajaxmsg('没有数据',0);
        foreach ($data_list as $key => $val){
            if($val['type']=='image'){
                $data_list[$key]['value'] = sysConfig('app_url').getFilePath($val['value']);
            }
        }
        return ajaxmsg('操作成功',200,$data_list);
    }
    /*
     * 修改网站设置列表
     */
    public function editConfigs()
    {
        $data = input();
        if(is_array($data)){
            $AdminConfig = new AdminConfig;
            $res = $AdminConfig->saveAll($data);
            $ret = SystemRedis::cacheConfig();
            cache('festival_' . date('Y', time()), '');
            if(!$res || !$ret) return ajaxmsg('操作失败',0);
            return ajaxmsg('操作成功',200);
        }
        return ajaxmsg('操作失败',0);
    }
}