<?php
declare (strict_types = 1);

namespace app\admin\controller;
//use think\captcha\facade\Captcha;
use app\admin\model\User as UserModel;
use think\facade\Session;
use util\Captcha;

class Login extends AdminBase
{
    
    public function index()
    {
        // 获取post数据 
        $data['username'] = input('username', '');
        $data['password'] = input('password', '');
        $data['captcha']  = input('captcha' , '');
        $data['remember'] = input('remember', '');
        if(!$data['username']) return ajaxmsg('用户名不能为空',400);
        if(!$data['password']) return ajaxmsg('请输入登录密码',400);
        $rememberme = isset($data['remember']) ? true : false;//记住账号功能 已经写入redis缓存，暂不需要
        // 验证码
        if(sysConfig('captcha_signin')) {
            if(!$data['captcha'])  return ajaxmsg('验证码不能为空',400);
            if(!app()->make(Captcha::class)->check($data['captcha'])){
            	//验证失败
            	return ajaxmsg('验证码错误或失效',400);
            }
        }
        // 验证数据
        $result = $this->validate($data, 'AdminUser.signin');
        if($result !== true) return ajaxmsg($result,400);
        // 登录
        $res_admin = UserModel::login($data['username'], $data['password'], $rememberme);
        //print_r($res_admin);return;
        if($res_admin && $res_admin['status'] == 1){
            // 记录行为
            //action_log('user_signin', 'admin_user', $uid, $uid);
            return ajaxmsg('登录成功！',200, $res_admin['data']);
        } 
        return ajaxmsg($res_admin['message'],400);
    }
    
    public function verify()
    {
        return app()->make(Captcha::class)->create();    
    }
}
