<?php
declare (strict_types = 1);

namespace app\admin\controller;
use think\facade\Db;
use think\facade\App;
use think\facade\Config;
use util\RedisUtil;
use util\QuotationRedis;

class Index extends AdminBase
{
    public function index()
    {
        $data = [];
        //当日交易会员数
        //$trade   = Db::name('stock_trust')->whereDay('trust_date')->group('sub_id')->count();
        //累计配资总数
        //$borrows = Db::name('stock_borrow')->where(['status'=>1])->group('member_id')->count();
        $borrows = Db::name('stock_borrow')->where(['status'=>1])->count();
        //代理商总数
        $agents  = Db::name('member')->where('agent_id','>',0)->where(['status'=>1])->count();
        //累计充值总额
        $r_total = money_convert(Db::name('money_recharge')->where(['status'=>1])->sum('money'));
        //累计提现总额
        $w_total = money_convert(Db::name('money_withdraw')->where(['status'=>1])->sum('money'));
        //累计操盘余额
        $account = money_convert(Db::name('money')->where('status=1')->sum('operate_account'));
        
        //总配资单
        $allCount   = Db::name('stock_borrow')->count();
        //免费体验
        $tryCount   = Db::name('stock_borrow')->where('type','4')->count();
        //按天配资
        $dayCount   = Db::name('stock_borrow')->where('type','1')->count();
        //按周配资
        $weekCount  = Db::name('stock_borrow')->where('type','2')->count();
        //按月配资
        $monthCount = Db::name('stock_borrow')->where('type','3')->count();
        //免息配资
        $freeCount  = Db::name('stock_borrow')->where('type','5')->count();
        //模拟操盘
        $mockCount  = Db::name('stock_borrow')->where('type','6')->count();
        
        //当日注册会员
        $m_today = Db::name('member')->where(['is_del'=>0])->whereDay('create_time')->count();
        //昨日注册会员
        $m_ysday = Db::name('member')->where(['is_del'=>0])->whereDay('create_time','yesterday')->count();
        //本周注册会员
        $m_weeks = Db::name('member')->where(['is_del'=>0])->whereWeek('create_time')->count();
        //本月注册会员
        $m_month = Db::name('member')->where(['is_del'=>0])->whereMonth('create_time')->count();
        //今年注册会员
        $m_years = Db::name('member')->where(['is_del'=>0])->whereYear('create_time')->count();
        //注册会员总数
        $m_total = Db::name('member')->where(['is_del'=>0])->count();
        //获取活跃股票
        $alivestocks = QuotationRedis::aliveStockList();
        $alivestocks = $alivestocks[0] ?: [];
        $data['alivecounts'] = count($alivestocks);
        foreach ($alivestocks as $key => $val){
            $item  = explode("_", $val);
            $Qdata = RedisUtil::getQuotationData($item[0],$item[1],true);
            if(!$Qdata['code']) continue;
            $data['alive'][] = $Qdata;
        }
        
        $data['rowlist'][] = ['name'=>'当前会员总数','value'=>$m_total,'icon'=>'el-icon-user-solid grid-con-1'];
        $data['rowlist'][] = ['name'=>'有效配资总数','value'=>$borrows,'icon'=>'el-icon-s-marketing grid-con-2'];
        $data['rowlist'][] = ['name'=>'有效代理总数','value'=>$agents ,'icon'=>'el-icon-s-custom grid-con-3'];
        
        $data['rowlist'][] = ['name'=>'累计充值总额','value'=>$r_total,'icon'=>'el-icon-s-finance grid-con-1'];
        $data['rowlist'][] = ['name'=>'累计提现总额','value'=>$w_total,'icon'=>'el-icon-wallet grid-con-2'];
        $data['rowlist'][] = ['name'=>'累计操盘余额','value'=>$account,'icon'=>'el-icon-money grid-con-3'];
        /*
        $data['borrow']['labels'] = ["免费体验","按天配资","按周配资","按月配资","免息配资","模拟操盘"];
        $data['borrow']['datasets'][] = [
            'data'  => [$tryCount,$dayCount,$weekCount,$monthCount,$freeCount,$mockCount]
        ];
        */
        $data['borrow']['labels'] = ["按天配资","按周配资","按月配资","免息配资"];
        $data['borrow']['datasets'][] = [
            'data'  => [$dayCount,$weekCount,$monthCount,$freeCount]
        ];
        
        $data['member']['labels'] = ["当日注册","昨日注册","本周注册","本月注册","今年注册"];
        $data['member']['datasets'][] = [
            'label' => '注册会员',
            'data'  => [$m_today,$m_ysday,$m_weeks,$m_month,$m_years]    
        ];
        $data['serinfo'] = $this->getServersInfo();
        return ajaxmsg('操作成功',200,$data);
    }
    public function welcome()
    {
        return ajaxmsg('操作成功',200,$this->request->server());
    }
     
    private function getServersInfo()
    {
        $info = [
            '操作系统'     => PHP_OS,
            'PHP运行方式'  => php_sapi_name(),
            'PHP版本'      => PHP_VERSION,
            '数据库版本'   => Config::get('database.default') .' '. $this->MysqlVersion(),
            'ThinkPHP版本' => App::version(),
            'SWOOLE版本'   => SWOOLE_VERSION,
            //'上传附件限制' => ini_get('upload_max_filesize'),
            //'执行时间限制' => ini_get('max_execution_time').'秒',
            '服务器时间'   => date("Y年n月j日 H:i:s"),
            '服务器地址'   => $this->request->server('HTTP_HOST'),
            //'服务器IP地址' => $this->request->server('REMOTE_ADDR'),
        ];
        return $info;
    }
    
    private function MysqlVersion()
    {
        $version = Db::query("select version() as ver");
        return $version[0]['ver'];
    }
}
