<?php
declare (strict_types = 1);

namespace app\admin\controller;
use app\apicom\model\Column as ColumnModel;
use app\apicom\model\Document as DocumentModel;
use think\facade\Db;

/**
 * 文档控制器
 * @package app\apicom\home
 */
class Document extends AdminBase
{
    /*
     * 获取文档列表
     */
    public function getList()
    {
        $title  = input('title', '');
        $column = input('column', '');
        $offset = input('pageSize',20, ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $order  = 'd.id desc';
        if(!empty($title))  $where[] = ['d.title','like', "%{$title}%"];
        if(!empty($column)) $where[] = ['c.name' ,'like', "%{$column}%"];
        $where[] = ['d.trash' ,'=', 0];
        $res = DocumentModel::getList($where,$order,$offset);
        if($res){
            return ajaxmsg('操作成功',200, $res); 
        }else {
            return ajaxmsg('操作失败',0);
        }
    }
    /*
     * 新增文档
     */
    public function addDoc()
    {
        $data = input();
		$data['cid'] = isset($data['cid'][0]) ? $data['cid'][0] : '';
		$data['uid'] = 1;
		$data['model']       = 2;
		$data['create_time'] = time();
		$data['update_time'] = time();
		$data['trash']       = 0;
		// 验证数据
		$result = $this->validate($data, 'Document.create');
		if ($result !== true) return ajaxmsg($result,0);
		Db::startTrans();
		$res = DocumentModel::strict(false)->insertGetId($data);
		//print_r($res);exit;
		if(!$res){
		    Db::rollback();
            return ajaxmsg('发布对应栏目失败',0);
		}
		$con = Db::name('cms_document_content')->insert(['aid'=>$res,'content'=>$data['content']]);
        if ($con) {
            Db::commit();
            return ajaxmsg('发布成功',200);
        } else {
            Db::rollback();
            return ajaxmsg('发布失败',0);
        }
        
    }
    public function editDoc()
    {
        $data = input();
		$data['update_time'] = time();
		$con_id  = $data['con_id'] ?? null;
		$content = $data['content'] ?? '';
		unset($data['con_id']);
		unset($data['content']);
		
		// 验证数据
		Db::startTrans();
		$res = DocumentModel::where('id',$data['id'])->update($data);
		$con = Db::name('cms_document_content')->where('aid',$data['id'])->update(['content'=>$content]);
        if ($res || $con) {
            Db::commit();
            return ajaxmsg('发布成功',200);
        } else {
            Db::rollback();
            return ajaxmsg('发布失败',0);
        }
        
    }
    /*
     * 启用/禁用 文档状态
     */
    public function doDisable()
    {
        $id     = input('id','', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $status = input('status','', ['trim', FILTER_SANITIZE_NUMBER_INT]);
		$res = DocumentModel::where('id', $id)->save(['status'=> $status]);
        if ($res) {
            return ajaxmsg('操作成功',200);
        } else {
            return ajaxmsg('操作失败',0);
        }
    }
    /*
     * 删除文档
     */
    public function delDoc()
    {
        $id  = input('id','', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        $doc = DocumentModel::where('id', $id)->find();
        if(empty($doc)) return ajaxmsg('查询失败',0);
		Db::startTrans();
		$res = DocumentModel::where('id', $id)->delete();
		$doc = Db::name('cms_document_content')->where('aid', $id)->delete();
        if ($res) {
            Db::commit();
            return ajaxmsg('操作成功',200);
        } else {
            Db::rollback();
            return ajaxmsg('操作失败',0);
        }
    }
    /*
     * 获取栏目
     */
    public function getColumns()
    {
        $res   = ColumnModel::where(['status'=>1])->field('id,name')->select()->toArray();
        $datas = [];
        foreach ($res as $k => $val){
            $datas[$k]['value'] = $val['id'];
            $datas[$k]['label'] = $val['name'];
        }
        if($res){
            return ajaxmsg('操作成功',200, $datas); 
        }else {
            return ajaxmsg('操作失败',0);
        }
    }
    /**
     * 文档详情页
     */
    public function getDetail()
    {
        $id    = input('id', '', ['trim', FILTER_SANITIZE_NUMBER_INT]);
        if (!$id) return ajaxmsg("缺少参数",0);
        // 获取文章内容
        $info = DocumentModel::getOne($id);
		if(!$info) return ajaxmsg('查询失败',0);
		return ajaxmsg('获取成功',200,$info);
    }
    
  
}