import config from "@/config"
import http from "@/utils/request"

export default{
	lists: {
		list: {
			url: `${config.API_URL}order/index/index`,
			name: "获得订单列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		detail: {
			url: `${config.API_URL}order/index/detail`,
			name: "订单详情",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}order/index/add`,
			name: "添加订单",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}order/index/edit`,
			name: "编辑订单",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}order/index/delete`,
			name: "删除订单",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		},
		send: {
			url: `${config.API_URL}order/index/send`,
			name: "发货",
			post: async function(params){
				return await http.put(this.url, params);
			}
		}
	},
	refund: {
		list: {
			url: `${config.API_URL}order/refund/index`,
			name: "获得退款列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		detail: {
			url: `${config.API_URL}order/refund/detail`,
			name: "退款详情",
			get: async function(params){
				return awaithttp.get(this.url, params);
			}
		},
		audit: {
			url: `${config.API_URL}order/refund/audit`,
			name: "退款审核",
			post: async function(params){
				return await http.put(this.url, params);
			}
		}
	},
	exchange: {
		list: {
			url: `${config.API_URL}order/exchange/index`,
			name: "获得置换列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},

	}
}
