<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Wechat\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Wechat\Services\NotifyService;

class Notify extends BaseController {

	public function order(Request $request, NotifyService $service){
		try {
			return $service->orderNotify($request);
		} catch (\Throwable $th) {
			$this->data['message'] = $th->getMessage();
			$this->data['code'] = 0;
		}

		return 'success';
	}

	public function refund(Request $request, NotifyService $service){
		try {
			return $service->refundNotify($request);
		} catch (\Throwable $th) {
			$this->data['message'] = $th->getMessage();
			$this->data['code'] = 0;
		}
		return 'success';
	}

	public function payment(Request $request, NotifyService $service){
		try {
			return $service->paymentNotify($request);
		} catch (\Throwable $th) {
			$this->data['message'] = $th->getMessage();
			$this->data['code'] = 0;
		}
		return 'success';
	}

	public function transfer(Request $request, NotifyService $service){
		try {
			return $service->transferNotify($request);
		} catch (\Throwable $th) {
			$this->data['message'] = $th->getMessage();
			$this->data['code'] = 0;
		}
		return 'success';
	}
}