<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
use Illuminate\Support\Facades\Route;

// 系统路由配置
Route::name('system.')->prefix('system')->middleware(['auth.check:admin'])->group(function () {
	Route::controller(Modules\System\Controllers\Admin\Index::class)->prefix('index')->name('index.')->group(function () {
		Route::get('/version', 'version')->name('version');
		Route::get('/info', 'info')->name('info');
		Route::post('/clearcache', 'clearcache')->name('clearcache');
	});
	Route::controller(Modules\System\Controllers\Admin\File::class)->prefix('file')->name('file.')->group(function () {
		Route::post('/upload', 'upload')->name('upload');
	});
	Route::controller(Modules\System\Controllers\Admin\Log::class)->prefix('log')->name('log.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::get('/my', 'my')->name('my');
		Route::post('/clear', 'clear')->name('clear');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\System\Controllers\Admin\Setting::class)->prefix('setting')->name('setting.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/save', 'save')->name('save');
		Route::delete('/delete', 'delete')->name('delete');
		Route::get('/fields', 'fields')->name('fields');
	});
	Route::controller(Modules\System\Controllers\Admin\Dict::class)->prefix('dict')->name('dict.')->group(function () {
		Route::get('/all', 'all')->name('all');
		Route::get('/lists', 'lists')->name('lists');
		Route::get('/category', 'category')->name('category');
		Route::post('/addcate', 'addcate')->name('addcate');
		Route::put('/editcate', 'editcate')->name('editcate');
		Route::delete('/deletecate', 'deletecate')->name('deletecate');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\System\Controllers\Admin\Area::class)->prefix('area')->name('area.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});
});
