<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
		Schema::create('system_logs', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->unsignedBigInteger('user_id')->comment('用户ID');
			$table->string('title')->comment('日志标题');
			$table->string('name')->comment('日志名称');
			$table->string('url')->comment('请求地址');
			$table->string('method')->comment('请求方法');
			$table->string('client_ip')->nullable()->comment('请求IP');
			$table->text('data')->nullable()->comment('请求数据');
			$table->text('remark')->nullable()->comment('备注');
			$table->text('browser')->nullable()->comment('浏览器');
			$table->tinyInteger('status')->default(1)->comment('状态码');
            $table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('系统日志表');
		});
		Schema::create('system_configs', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('title')->comment('配置标题');
			$table->string('name')->comment('配置名称');
			$table->string('values')->nullable()->comment('配置值');
			$table->string('type')->comment('配置类型');
			$table->string('group')->comment('配置分组');
			$table->string('remark')->nullable()->comment('配置备注');
			$table->string('sort')->default(0)->comment('排序');
			$table->tinyInteger('status')->default(1)->comment('状态');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('系统配置表');
		});
		Schema::create('system_dicts', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('title')->comment('字典标题');
			$table->string('values')->comment('字典值');
			$table->string('group_id')->comment('字典分组');
			$table->string('group_name')->comment('字典分组标识');
			$table->string('sort')->default(0)->comment('排序');
			$table->tinyInteger('status')->default(1)->comment('状态');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('系统字典表');
		});
		Schema::create('system_dict_groups', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('parent_id')->default(0)->comment('父级id');
			$table->string('title')->comment('字典分组标题');
			$table->string('name')->comment('字典分组名称');
			$table->string('sort')->default(0)->comment('排序');
			$table->tinyInteger('status')->default(1)->comment('状态');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('系统字典分组表');
		});
		Schema::create('system_areas', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('code')->comment('城市编码');
			$table->string('parent_code')->default(0)->comment('父级id');
			$table->string('title')->comment('城市名称');
			$table->tinyInteger('status')->default(1)->comment('状态');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('系统城市数据表');
		});
		Schema::create('system_crontabs', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('title')->comment('定时任务标题');
			$table->string('command')->comment('定时任务命令');
			$table->string('expression')->comment('定时任务表达式');
			$table->string('status')->default(1)->comment('状态 1正常 2禁用');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('系统定时任务表');
		});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
		Schema::drop('system_logs');
		Schema::drop('system_configs');
		Schema::drop('system_dicts');
		Schema::drop('system_dict_groups');
		Schema::drop('system_areas');
		Schema::drop('system_crontabs');
    }
};
