<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\System\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\System\Services\DictService;
use Modules\System\Services\QrcodeService;

class Index extends BaseController {

	/**
	 * @title 数据字典列表
	 *
	 * @return void
	 */
	public function dict(Request $request, DictService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	public function config(Request $request){
		try {
			$this->data['data'] = cache()->get('config');
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 生成二维码
	 *
	 * @param Request $request
	 * @return void
	 */
	public function qrcode(Request $request, QrcodeService $service){
		try {
			$this->data['data'] = $service->getQrcode($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

}
