<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Store\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Store\Services\StoreService;

class Index extends BaseController{

	/**
	 * @title 店铺列表
	 *
	 * @param Request $request
	 * @param StoreService $service
	 * @return void
	 */
	public function index(Request $request, StoreService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加店铺
	 *
	 * @param Request $request
	 * @param StoreService $service
	 * @return void
	 */
	public function add(Request $request, StoreService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 修改店铺
	 *
	 * @param Request $request
	 * @param StoreService $service
	 * @return void
	 */
	public function edit(Request $request, StoreService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 审核店铺
	 *
	 * @param Request $request
	 * @param StoreService $service
	 * @return void
	 */
	public function audit(Request $request, StoreService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 复制店铺
	 *
	 * @param Request $request
	 * @param StoreService $service
	 * @return void
	 */
	public function copy(Request $request, StoreService $service){
		try {
			$this->data['data'] = $service->copyStore($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除店铺
	 *
	 * @param Request $request
	 * @param StoreService $service
	 * @return void
	 */
	public function delete(Request $request, StoreService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}
}
