<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Order\Models;

use App\Models\BaseModel;

class OrderItem extends BaseModel {

	protected $table = 'order_item';
	protected $fillable = ['goods_id', 'member_id', 'store_id', 'goods_sku_id', 'title', 'cover', 'price', 'integral', 'discount_price', 'num', 'total_price', 'total_integral', 'delivery_type', 'status'];
	// protected $hidden = ['deleted_at'];

	protected function casts(): array {
		return [
			'created_at' => 'datetime:Y-m-d H:i:s',
			'updated_at' => 'datetime:Y-m-d H:i:s',
		];
	}

	public function goods(){
		return $this->belongsTo('Modules\Goods\Models\Goods', 'goods_id', 'id');
	}
	public function sku(){
		return $this->belongsTo('Modules\Goods\Models\GoodsSku', 'goods_sku_id', 'id');
	}

	public function order(){
		return $this->belongsTo('Modules\Order\Models\Order', 'order_id', 'id');
	}

	public function store(){
		return $this->belongsTo('Modules\Store\Models\Store', 'store_id', 'id');
	}
	public function member(){
		return $this->belongsTo('Modules\Member\Models\Member', 'member_id', 'uid');
	}
}
