<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
use Illuminate\Support\Facades\Route;
use Modules\Member\Controllers\MemberController;

// 会员管理路由配置
Route::name('member.')->prefix('member')->middleware(['auth.check:admin'])->group(function () {
	Route::controller(Modules\Member\Controllers\Admin\Index::class)->prefix('index')->name('index.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Member\Controllers\Admin\Level::class)->prefix('level')->name('level.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Member\Controllers\Admin\Account::class)->prefix('account')->name('account.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
		Route::post('/withdraw', 'withdraw')->name('withdraw');
	});
	Route::controller(Modules\Member\Controllers\Admin\Score::class)->prefix('score')->name('score.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Member\Controllers\Admin\Polymer::class)->prefix('polymer')->name('polymer.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Member\Controllers\Admin\Promoter::class)->prefix('promoter')->name('promoter.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::put('/audit', 'audit')->name('audit');
	});
	Route::controller(Modules\Member\Controllers\Admin\Sign::class)->prefix('sign')->name('sign.')->group(function () {
		Route::get('/index', 'index')->name('index');
	});
});
