<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void {
		Schema::create('member_promoter', function (Blueprint $table) {
			$table->id();
			$table->unsignedBigInteger('member_id')->default(0)->comment('会员ID');
			$table->string('name')->nullable()->comment('姓名');
			$table->string('nickname')->nullable()->comment('昵称');
			$table->string('mobile')->nullable()->comment('手机号码');
			$table->tinyInteger('sex')->default(0)->comment('性别');
			$table->string('avatar')->nullable()->comment('头像');
			$table->unsignedBigInteger('category_id')->default(0)->comment('分类ID');
			$table->string('area')->nullable()->comment('所属区域');
			$table->tinyInteger('status')->default(0)->comment('状态');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('会员推广员表');
		});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void {
		Schema::dropIfExists('member_promoter');
    }
};
