<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Services;

use Modules\Member\Models\MemberCollect;

class CollectService {

	/**
	 * @title 获取会员列表
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function getDataList($request){
		$map = [];

		$query = MemberCollect::query();

		if ($request->filled('title')) {
			$map[] = ['title', 'like', '%' . $request->input('title') . '%'];
		}
		if ($request->filled('name')) {
			$map[] = ['name', 'like', '%' . $request->input('name') . '%'];
		}
		if ($request->filled('type')) {
			$map[] = ['type', '=', $request->input('type')];
			if ($request->input('type') == 'goods'){
				$query->with(['goods']);
			}else if($request->input('type') == 'store'){
				$query->with(['store', 'store.category']);
			}
		}
		if ($request->filled('is_user')) {
			$map[] = ['member_id', '=', auth('api')->user()['uid']];
		}

		$query = $query->where($map)->orderBy('id', 'desc');

		if($request->filled('page')){
			$data = [
				'total' => $query->count(),
				'page' => $request->input('page', 1),
				'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
			];
		}else{
			$data = $query->get();
		}
		return $data;
	}

	/**
	 * @title 添加会员
	 *
	 * @param Request $request
	 * @param MemberService $service
	 * @return void
	 */
	public function create($request){
		$request->validate([
				'goods_id' => 'required_if:type,goods',
				'store_id' => 'required_if:type,store',
				'type'     => 'required'
			],
			[
				'goods_id.required_if' => '商品不能为空',
				'store_id.required_if' => '店铺不能为空',
				'type.required' => '类型不能为空'
			]
		);
		$collect = new MemberCollect();
		foreach($collect->setFilterFields($request->all()) as $key => $value){
			$collect->$key = $value;
		}
		$collect->member_id = auth('api')->user()['uid'];

		$collect->save();
		return $collect;
	}


	public function delete($request){
		$request->validate([
				'goods_id' => 'required_if:type,goods',
				'store_id' => 'required_if:type,store',
				'type'     => 'required'
			],
			[
				'goods_id.required_if' => '商品不能为空',
				'store_id.required_if' => '店铺不能为空',
				'type.required' => '类型不能为空'
			]
		);

		if($request->input('type') == 'goods'){
			$collect = MemberCollect::where('member_id', auth('api')->user()['uid'])->where('type', 'goods')->where('goods_id', $request->input('goods_id'))->first();
		}else if($request->input('type') == 'store'){
			$collect = MemberCollect::where('member_id', auth('api')->user()['uid'])->where('type', 'store')->where('store_id', $request->input('store_id'))->first();
		}

		if($collect){
			$collect->delete();
			return true;
		}else{
			return false;
		}
	}
}
